<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Fare System Routes
$route['fareSettings'] = 'FareSettings/index';
$route['fareSettings/addConfiguration'] = 'FareSettings/addConfiguration';
$route['fareSettings/editConfiguration/(:any)'] = 'FareSettings/editConfiguration/$1';
$route['fareSettings/saveConfiguration'] = 'FareSettings/saveConfiguration';
$route['fareSettings/updateConfiguration'] = 'FareSettings/updateConfiguration';
$route['fareSettings/deleteConfiguration/(:any)'] = 'FareSettings/deleteConfiguration/$1';
$route['fareSettings/cloneConfiguration/(:any)'] = 'FareSettings/cloneConfiguration/$1';
$route['fareSettings/testCalculation'] = 'FareSettings/testCalculation';
$route['fareSettings/getConfiguration'] = 'FareSettings/getConfiguration';
$route['fareSettings/exportConfigurations'] = 'FareSettings/exportConfigurations';
$route['fareSettings/importConfigurations'] = 'FareSettings/importConfigurations';
$route['fareSettings/bulkUpdate'] = 'FareSettings/bulkUpdate';

// City Management Routes
$route['fareSettings/addCity'] = 'FareSettings/addCity';
$route['fareSettings/saveCity'] = 'FareSettings/saveCity';
$route['fareSettings/editCity/(:any)'] = 'FareSettings/editCity/$1';
$route['fareSettings/updateCity'] = 'FareSettings/updateCity';
$route['fareSettings/deleteCity/(:any)'] = 'FareSettings/deleteCity/$1';
$route['fareSettings/viewCitySettings/(:any)'] = 'FareSettings/viewCitySettings/$1';

// Fare API Routes
$route['fareApi/calculateFare'] = 'FareApi/calculateFare';
$route['fareApi/getEstimate'] = 'FareApi/getEstimate';
$route['fareApi/getCancellationFee'] = 'FareApi/getCancellationFee';
$route['fareApi/getConfigurations'] = 'FareApi/getConfigurations';
$route['fareApi/getCities'] = 'FareApi/getCities';
$route['fareApi/getVehicleClasses'] = 'FareApi/getVehicleClasses';
$route['fareApi/getServiceTypes'] = 'FareApi/getServiceTypes';
$route['fareApi/test'] = 'FareApi/test';
$route['fareApi/getBookingFare/(:any)'] = 'FareApi/getBookingFare/$1';

// Dashboard Live Monitoring Routes
$route['dashboard/getLiveData'] = 'Dashboard/getLiveData';

// Wallet Management Routes
$route['wallet'] = 'Wallet/index';
$route['wallet/topup'] = 'Wallet/topup';
$route['wallet/withdrawal'] = 'Wallet/withdrawal';
$route['wallet/export'] = 'Wallet/export';

// User Management Routes
$route['userManagement'] = 'UserManagement/index';
$route['userManagement/suspend'] = 'UserManagement/suspend';
$route['userManagement/unsuspend'] = 'UserManagement/unsuspend';
$route['userManagement/approve'] = 'UserManagement/approve';
$route['userManagement/suspensionHistory'] = 'UserManagement/suspensionHistory';

// Role Management Routes
$route['roleManagement'] = 'RoleManagement/index';
$route['roleManagement/create'] = 'RoleManagement/create';
$route['roleManagement/edit/(:any)'] = 'RoleManagement/edit/$1';
$route['roleManagement/delete/(:any)'] = 'RoleManagement/delete/$1';
$route['roleManagement/userRoles'] = 'RoleManagement/userRoles';
$route['roleManagement/updateUserRole'] = 'RoleManagement/updateUserRole';
$route['roleManagement/getRolePermissions'] = 'RoleManagement/getRolePermissions';

// Parcel Delivery Routes
$route['parcel/editWeightBand/(:any)'] = 'Parcel/editWeightBand/$1';
$route['parcel/editSizeCategory/(:any)'] = 'Parcel/editSizeCategory/$1';

// Food Delivery Routes
$route['food/settings'] = 'Food/settings';
$route['food/updateSettings'] = 'Food/updateSettings';

// Parcel Delivery API Routes
$route['api/parcel/calculate'] = 'ParcelFareApi/calculate';
$route['api/parcel/estimate'] = 'ParcelFareApi/estimate';
$route['api/parcel/settings'] = 'ParcelFareApi/settings';
$route['api/parcel/weight-bands'] = 'ParcelFareApi/weightBands';
$route['api/parcel/size-categories'] = 'ParcelFareApi/sizeCategories';
$route['api/parcel/stats'] = 'ParcelFareApi/stats';
$route['api/parcel/docs'] = 'ParcelFareApi/docs';
$route['api/parcel/adminShare'] = 'ParcelFareApi/getAdminShare';

// Finance Dashboard Routes
$route['finance/dashboard'] = 'Finance/dashboard';
$route['finance/export'] = 'Finance/export';

// Driver Selfie Check API Routes
$route['api/driver/selfie/verify'] = 'DriverSelfieApi/verifySelfie';
$route['api/driver/selfie/checkRequired'] = 'DriverSelfieApi/checkRequired';

// Driving Hours Dashboard Routes
$route['drivingHours/dashboard'] = 'DrivingHours/dashboard';
$route['drivingHours/getDrivingHoursData'] = 'DrivingHours/getDrivingHoursData';

// Driver Settings Routes
$route['dashboard/driverSettings'] = 'Dashboard/driverSettings';
$route['dashboard/saveDriverSettings'] = 'Dashboard/saveDriverSettings';

// Audit Log Routes
$route['auditLog'] = 'AuditLog/index';
$route['auditLog/loginLogs'] = 'AuditLog/loginLogs';
$route['auditLog/adminActions'] = 'AuditLog/adminActions';
$route['auditLog/userActivity'] = 'AuditLog/userActivity';
$route['auditLog/userActivity/(:any)'] = 'AuditLog/userActivity/$1';
$route['auditLog/ipHistory'] = 'AuditLog/ipHistory';
$route['auditLog/ipHistory/(:any)'] = 'AuditLog/ipHistory/$1';
$route['auditLog/suspiciousActivity'] = 'AuditLog/suspiciousActivity';
$route['auditLog/exportCSV'] = 'AuditLog/exportCSV';
$route['auditLog/exportExcel'] = 'AuditLog/exportExcel';
$route['auditLog/exportPDF'] = 'AuditLog/exportPDF';

// Audit Log API Routes (for mobile apps)
$route['api/auditLog/logActivity'] = 'AuditLogApi/logActivity';
$route['api/auditLog/logLogin'] = 'AuditLogApi/logLogin';
$route['api/auditLog/logLogout'] = 'AuditLogApi/logLogout';
$route['api/auditLog/userActivity'] = 'AuditLogApi/userActivity';
$route['api/auditLog/userActivity/(:any)'] = 'AuditLogApi/userActivity/$1';

