<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Multi File Upload</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
    #drop-zone {
        border: 2px dashed #007BFF;
        padding: 30px;
        text-align: center;
        color: #6C757D;
        cursor: pointer;
    }

    #drop-zone.dragover {
        background-color: #E9F5FF;
    }
    </style>
</head>

<body class="p-5">
    <div class="container">
        <h3 class="mb-4">Multi File Upload (Drag & Drop)</h3>
        <form id="upload-form">
            <div id="drop-zone" class="mb-3">
                Drag & drop files here or click to browse
                <input type="file" id="file-input" name="files" multiple hidden />
            </div>
            <ul id="file-list" class="mb-3 list-group"></ul>
            <button type="submit" class="btn btn-primary">Upload</button>
        </form>
    </div>
    <script>
    const dropZone = document.getElementById("drop-zone");
    const fileInput = document.getElementById("file-input");
    const fileList = document.getElementById("file-list");
    let selectedFiles = [];
    // Show file names
    const updateFileList = () => {
        fileList.innerHTML = "";
        selectedFiles.forEach((file, index) => {
            const li = document.createElement("li");
            li.className = "list-group-item";
            li.textContent = `${index + 1}. ${file.name}`;
            fileList.appendChild(li);
        });
    };
    // Click to open file dialog
    dropZone.addEventListener("click", () => fileInput.click());
    // Files selected via file input
    fileInput.addEventListener("change", (e) => {
        selectedFiles = Array.from(e.target.files);
        updateFileList();
    });
    // Drag & drop events
    dropZone.addEventListener("dragover", (e) => {
        e.preventDefault();
        dropZone.classList.add("dragover");
    });
    dropZone.addEventListener("dragleave", () => {
        dropZone.classList.remove("dragover");
    });
    dropZone.addEventListener("drop", (e) => {
        e.preventDefault();
        dropZone.classList.remove("dragover");
        const files = Array.from(e.dataTransfer.files);
        selectedFiles = selectedFiles.concat(files);
        updateFileList();
    });
    // Form submit
    document
        .getElementById("upload-form")
        .addEventListener("submit", function(e) {
            e.preventDefault();
            if (selectedFiles.length === 0) {
                alert("Please select or drop at least one file.");
                return;
            }
            const formData = new FormData();
            selectedFiles.forEach((file, index) => {
                formData.append("files[]", file);
            });
            console.log("Uploading files:", selectedFiles);
            // Example: Send to server
            // fetch('/upload', {
            //   method: 'POST',
            //   body: formData
            // }).then(res => res.json())
            //   .then(data => console.log('Uploaded:', data))
            //   .catch(err => console.error('Error:', err));
        });
    </script>
</body>

</html>