<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
    .driver-card {
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .driver-image {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        object-fit: cover;
    }
    .status-badge {
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 0.85rem;
    }
    .status-online {
        background-color: #28a745;
        color: white;
    }
    .status-offline {
        background-color: #dc3545;
        color: white;
    }
</style>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Fleet Drivers Management</h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Total Drivers: <?= $driverCount ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered" id="driversTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Photo</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Vehicles</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($drivers)): ?>
                            <?php foreach ($drivers as $driverId => $driver): ?>
                                <tr>
                                    <td>
                                        <?php if (isset($driver['image']) && !empty($driver['image'])): ?>
                                            <img class="driver-image" src="<?= htmlspecialchars($driver['image']) ?>" alt="Driver Photo">
                                        <?php else: ?>
                                            <img class="driver-image" src="http://placehold.jp/100x100.png" alt="No Photo">
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $fullName = '';
                                        if (isset($driver['fullName'])) {
                                            $fullName = $driver['fullName'];
                                        } elseif (isset($driver['firstName'])) {
                                            $fullName = $driver['firstName'];
                                            if (isset($driver['lastName'])) {
                                                $fullName .= ' ' . $driver['lastName'];
                                            }
                                        }
                                        echo htmlspecialchars($fullName ?: 'Unknown');
                                        ?>
                                    </td>
                                    <td><?= isset($driver['email']) ? htmlspecialchars($driver['email']) : '-' ?></td>
                                    <td><?= isset($driver['phoneNumber']) ? htmlspecialchars($driver['phoneNumber']) : (isset($driver['phone']) ? htmlspecialchars($driver['phone']) : '-') ?></td>
                                    <td>
                                        <?php 
                                        $isOnline = isset($driver['isOnline']) ? $driver['isOnline'] : false;
                                        $statusClass = $isOnline ? 'status-online' : 'status-offline';
                                        $statusText = $isOnline ? 'Online' : 'Offline';
                                        ?>
                                        <span class="status-badge <?= $statusClass ?>"><?= $statusText ?></span>
                                    </td>
                                    <td>
                                        <?php 
                                        $vehicleCount = isset($driver['vehicleCount']) ? $driver['vehicleCount'] : 0;
                                        ?>
                                        <span class="badge badge-info"><?= $vehicleCount ?> Vehicle(s)</span>
                                    </td>
                                    <td>
                                        <button class="btn btn-info btn-sm mb-1" onclick="viewDriverDetails('<?= $driverId ?>')">
                                            <i class="fa fa-eye"></i> View Details
                                        </button>
                                        <?php if (isset($driver['vehicles']) && !empty($driver['vehicles'])): ?>
                                            <button class="btn btn-secondary btn-sm mb-1" onclick="viewVehicles('<?= $driverId ?>')">
                                                <i class="fa fa-car"></i> Vehicles
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">No drivers found for this fleet</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Driver Details Modal -->
<div class="modal fade" id="driverDetailsModal" tabindex="-1" aria-labelledby="driverDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="driverDetailsModalLabel">Driver Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="driverDetailsContent">
                <!-- Driver details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('#driversTable').DataTable({
        "order": [[1, "asc"]],
        "pageLength": 25
    });
});

function viewDriverDetails(driverId) {
    // You can implement AJAX call to get detailed driver information
    // For now, just show a simple message
    $('#driverDetailsContent').html('<p>Loading driver details...</p>');
    $('#driverDetailsModal').modal('show');
    // TODO: Implement AJAX call to fetch detailed driver information
}

function viewVehicles(driverId) {
    // You can implement navigation to vehicle details page
    alert('View vehicles for driver: ' + driverId);
    // TODO: Implement navigation or modal to show vehicles
}
</script>

