<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
    .hours-card {
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .hours-card.daily { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
    .hours-card.weekly { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; }
    .hours-card.monthly { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; }
    .alert-exceeded { background-color: #dc3545; color: white; }
    .alert-warning { background-color: #ffc107; color: #000; }
    .limit-badge { padding: 5px 10px; border-radius: 5px; font-weight: bold; }
</style>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Driving Hours Dashboard</h2>
            </div>
        </div>
    </div>

    <!-- Daily Driving Limit Settings -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Daily Driving Limit Settings</h6>
                </div>
                <div class="card-body">
                    <form method="post" action="<?= base_url('FleetOwnerDashboard/save_driving_limit') ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dailyLimit">Daily Driving Limit (Hours)</label>
                                    <input type="number" class="form-control" id="dailyLimit" name="dailyLimit" 
                                           value="<?= $dailyLimit ?>" min="1" max="24" step="0.5" required>
                                    <small class="form-text text-muted">Set the maximum daily driving hours allowed for drivers</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">Save Limit</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Fatigue Alerts -->
    <?php if (!empty($fatigueAlerts)): ?>
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow border-danger">
                <div class="card-header py-3 bg-danger text-white">
                    <h6 class="m-0 font-weight-bold"><i class="fa fa-exclamation-triangle"></i> Fatigue Alerts</h6>
                </div>
                <div class="card-body">
                    <?php foreach ($fatigueAlerts as $alert): ?>
                        <div class="alert <?= $alert['status'] == 'exceeded' ? 'alert-danger' : 'alert-warning' ?> mb-2">
                            <strong><?= isset($alert['driverName']) ? htmlspecialchars($alert['driverName']) : 'Driver' ?></strong>: 
                            <?= htmlspecialchars($alert['message']) ?> 
                            (<?= $alert['dailyHours'] ?> hours / <?= $alert['limit'] ?> hours limit)
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Driving Hours Summary -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="hours-card daily">
                <h5><i class="fa fa-calendar-day"></i> Today's Total</h5>
                <h2><?= number_format(array_sum(array_column($drivingHours, 'daily')), 2) ?> hrs</h2>
            </div>
        </div>
        <div class="col-md-4">
            <div class="hours-card weekly">
                <h5><i class="fa fa-calendar-week"></i> This Week's Total</h5>
                <h2><?= number_format(array_sum(array_column($drivingHours, 'weekly')), 2) ?> hrs</h2>
            </div>
        </div>
        <div class="col-md-4">
            <div class="hours-card monthly">
                <h5><i class="fa fa-calendar-alt"></i> This Month's Total</h5>
                <h2><?= number_format(array_sum(array_column($drivingHours, 'monthly')), 2) ?> hrs</h2>
            </div>
        </div>
    </div>

    <!-- Individual Driver Hours -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Individual Driver Driving Hours</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="hoursTable">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Driver Name</th>
                                    <th>Email</th>
                                    <th>Daily Hours</th>
                                    <th>Weekly Hours</th>
                                    <th>Monthly Hours</th>
                                    <th>Total Hours</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($drivingHours)): ?>
                                    <?php foreach ($drivingHours as $driverId => $hours): ?>
                                        <tr>
                                            <td><?= isset($hours['driverName']) ? htmlspecialchars($hours['driverName']) : 'Unknown' ?></td>
                                            <td><?= isset($hours['driverEmail']) ? htmlspecialchars($hours['driverEmail']) : '-' ?></td>
                                            <td>
                                                <strong><?= number_format($hours['daily'], 2) ?></strong> hrs
                                                <?php if ($hours['daily'] >= $dailyLimit): ?>
                                                    <span class="badge badge-danger ml-2">Exceeded</span>
                                                <?php elseif ($hours['daily'] >= ($dailyLimit * 0.9)): ?>
                                                    <span class="badge badge-warning ml-2">Warning</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= number_format($hours['weekly'], 2) ?> hrs</td>
                                            <td><?= number_format($hours['monthly'], 2) ?> hrs</td>
                                            <td><?= number_format($hours['total'], 2) ?> hrs</td>
                                            <td>
                                                <?php 
                                                $statusClass = 'badge-success';
                                                $statusText = 'Normal';
                                                if ($hours['daily'] >= $dailyLimit) {
                                                    $statusClass = 'badge-danger';
                                                    $statusText = 'Exceeded';
                                                } elseif ($hours['daily'] >= ($dailyLimit * 0.9)) {
                                                    $statusClass = 'badge-warning';
                                                    $statusText = 'Warning';
                                                }
                                                ?>
                                                <span class="badge <?= $statusClass ?>"><?= $statusText ?></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No driving hours data available</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {
    $('#hoursTable').DataTable({
        "order": [[2, "desc"]],
        "pageLength": 25
    });
});
</script>

