<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
    .verification-card {
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .verification-passed {
        border-left: 4px solid #28a745;
        background-color: #d4edda;
    }
    .verification-failed {
        border-left: 4px solid #dc3545;
        background-color: #f8d7da;
    }
    .verification-pending {
        border-left: 4px solid #ffc107;
        background-color: #fff3cd;
    }
    .image-comparison {
        display: flex;
        gap: 20px;
        margin: 15px 0;
    }
    .image-box {
        flex: 1;
        text-align: center;
    }
    .image-box img {
        max-width: 100%;
        height: 200px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }
    .match-score {
        font-size: 1.5rem;
        font-weight: bold;
        padding: 10px;
        border-radius: 5px;
    }
    .score-high { background-color: #28a745; color: white; }
    .score-medium { background-color: #ffc107; color: #000; }
    .score-low { background-color: #dc3545; color: white; }
</style>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Identity Selfie Verification</h2>
            </div>
        </div>
    </div>

    <!-- Info Card -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header py-3 bg-info text-white">
                    <h6 class="m-0 font-weight-bold"><i class="fa fa-info-circle"></i> About Identity Verification</h6>
                </div>
                <div class="card-body">
                    <p>Identity verification is automatically triggered:</p>
                    <ul>
                        <li>At the start of each driver shift</li>
                        <li>After every X hours of driving (configurable)</li>
                    </ul>
                    <p><strong>Note:</strong> If a selfie doesn't match the profile picture, the driver will be automatically suspended and an alert will be sent to administrators.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Verification Records -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Verification History</h6>
                </div>
                <div class="card-body">
                    <?php if (!empty($verifications)): ?>
                        <?php foreach ($verifications as $verification): ?>
                            <div class="verification-card <?php 
                                $status = isset($verification['status']) ? $verification['status'] : 'pending';
                                if ($status == 'passed' || $status == 'verified') {
                                    echo 'verification-passed';
                                } elseif ($status == 'failed' || $status == 'mismatch') {
                                    echo 'verification-failed';
                                } else {
                                    echo 'verification-pending';
                                }
                            ?>">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h5>
                                            <i class="fa fa-user"></i> 
                                            <?= isset($verification['driverName']) ? htmlspecialchars($verification['driverName']) : 'Unknown Driver' ?>
                                            <span class="badge badge-<?php 
                                                $status = isset($verification['status']) ? $verification['status'] : 'pending';
                                                if ($status == 'passed' || $status == 'verified') {
                                                    echo 'success';
                                                } elseif ($status == 'failed' || $status == 'mismatch') {
                                                    echo 'danger';
                                                } else {
                                                    echo 'warning';
                                                }
                                            ?> ml-2">
                                                <?= ucfirst($status) ?>
                                            </span>
                                        </h5>
                                    </div>
                                </div>
                                
                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <p><strong>Date/Time:</strong> 
                                            <?php 
                                            if (isset($verification['timestamp'])) {
                                                $timestamp = is_numeric($verification['timestamp']) ? $verification['timestamp'] / 1000 : strtotime($verification['timestamp']);
                                                echo date('Y-m-d H:i:s', $timestamp);
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </p>
                                        <p><strong>Trigger:</strong> <?= isset($verification['trigger']) ? htmlspecialchars($verification['trigger']) : 'Manual' ?></p>
                                        <?php if (isset($verification['matchScore'])): ?>
                                            <p><strong>Match Score:</strong> 
                                                <span class="match-score <?php 
                                                    $score = (float)$verification['matchScore'];
                                                    if ($score >= 80) echo 'score-high';
                                                    elseif ($score >= 60) echo 'score-medium';
                                                    else echo 'score-low';
                                                ?>">
                                                    <?= number_format($score, 1) ?>%
                                                </span>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php if (isset($verification['suspended']) && $verification['suspended']): ?>
                                            <p class="text-danger"><strong><i class="fa fa-ban"></i> Driver Suspended</strong></p>
                                        <?php endif; ?>
                                        <?php if (isset($verification['adminAlerted']) && $verification['adminAlerted']): ?>
                                            <p class="text-info"><strong><i class="fa fa-bell"></i> Admin Alerted</strong></p>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Image Comparison -->
                                <?php if (isset($verification['selfieImage']) || isset($verification['profileImage'])): ?>
                                    <div class="image-comparison mt-3">
                                        <div class="image-box">
                                            <h6>Profile Picture</h6>
                                            <?php if (isset($verification['profileImage']) && !empty($verification['profileImage'])): ?>
                                                <img src="<?= htmlspecialchars($verification['profileImage']) ?>" alt="Profile Picture">
                                            <?php elseif (isset($verification['driverImage']) && !empty($verification['driverImage'])): ?>
                                                <img src="<?= htmlspecialchars($verification['driverImage']) ?>" alt="Profile Picture">
                                            <?php else: ?>
                                                <img src="http://placehold.jp/200x200.png" alt="No Profile Picture">
                                            <?php endif; ?>
                                        </div>
                                        <div class="image-box">
                                            <h6>Selfie Taken</h6>
                                            <?php if (isset($verification['selfieImage']) && !empty($verification['selfieImage'])): ?>
                                                <img src="<?= htmlspecialchars($verification['selfieImage']) ?>" alt="Selfie">
                                            <?php else: ?>
                                                <img src="http://placehold.jp/200x200.png" alt="No Selfie">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if (isset($verification['notes']) && !empty($verification['notes'])): ?>
                                    <div class="mt-3">
                                        <p><strong>Notes:</strong> <?= htmlspecialchars($verification['notes']) ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No identity verification records found.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

