<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
    .stat-card {
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    .stat-card .icon {
        font-size: 3rem;
        opacity: 0.8;
    }
    .stat-card .value {
        font-size: 2rem;
        font-weight: bold;
        margin: 10px 0;
    }
    .stat-card .label {
        font-size: 0.9rem;
        color: #666;
        text-transform: uppercase;
    }
    .revenue-card { background: linear-gradient(135deg,rgb(98, 100, 109) 0%, #764ba2 100%); color: white; }
    .drivers-card { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; }
    .completed-card { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; }
    .cancelled-card { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); color: white; }
    .performance-table { margin-top: 20px; }
    .badge-rating { background-color: #28a745; color: white; padding: 5px 10px; border-radius: 5px; }
    .balance-positive { color: #28a745; font-weight: bold; }
    .balance-negative { color: #dc3545; font-weight: bold; }
    .balance-pending { color: #ffc107; font-weight: bold; }
</style>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Fleet Owner Dashboard</h2>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-body">
                    <h5 class="card-title">Quick Actions</h5>
                    <a href="<?= base_url('FleetOwnerDashboard/drivers') ?>" class="btn btn-primary mr-2">
                        <i class="fa fa-users"></i> Manage Drivers
                    </a>
                    <a href="<?= base_url('FleetOwnerDashboard/rides') ?>" class="btn btn-info mr-2">
                        <i class="fa fa-car"></i> Manage Rides
                    </a>
                    <a href="<?= base_url('FleetOwnerDashboard') ?>" class="btn btn-secondary">
                        <i class="fa fa-dashboard"></i> Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue Statistics -->
    <div class="row">
        <div class="col-md-4">
            <div class="stat-card revenue-card">
                <div class="icon"><i class="fa fa-dollar-sign"></i></div>
                <div class="value">$<?= number_format($revenue['total'], 2) ?></div>
                <div class="label">Total Revenue</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card revenue-card">
                <div class="icon"><i class="fa fa-calendar-day"></i></div>
                <div class="value">$<?= number_format($revenue['today'], 2) ?></div>
                <div class="label">Today's Revenue</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card revenue-card">
                <div class="icon"><i class="fa fa-calendar-alt"></i></div>
                <div class="value">$<?= number_format($revenue['month'], 2) ?></div>
                <div class="label">This Month's Revenue</div>
            </div>
        </div>
    </div>

    <!-- Drivers and Rides Statistics -->
    <div class="row">
        <div class="col-md-3">
            <a href="<?= base_url('FleetOwnerDashboard/drivers') ?>" style="text-decoration: none; color: inherit;">
                <div class="stat-card drivers-card" style="cursor: pointer;">
                    <div class="icon"><i class="fa fa-users"></i></div>
                    <div class="value"><?= $driverCount ?></div>
                    <div class="label">Total Drivers</div>
                    <small style="opacity: 0.8;">Click to manage</small>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="<?= base_url('FleetOwnerDashboard/rides') ?>" style="text-decoration: none; color: inherit;">
                <div class="stat-card completed-card" style="cursor: pointer;">
                    <div class="icon"><i class="fa fa-check-circle"></i></div>
                    <div class="value"><?= $ridesStats['completed'] ?></div>
                    <div class="label">Completed Rides</div>
                    <small>Today: <?= $ridesStats['todayCompleted'] ?></small>
                    <small style="opacity: 0.8; display: block; margin-top: 5px;">Click to manage rides</small>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="<?= base_url('FleetOwnerDashboard/rides') ?>" style="text-decoration: none; color: inherit;">
                <div class="stat-card cancelled-card" style="cursor: pointer;">
                    <div class="icon"><i class="fa fa-times-circle"></i></div>
                    <div class="value"><?= $ridesStats['cancelled'] ?></div>
                    <div class="label">Cancelled Rides</div>
                    <small>Today: <?= $ridesStats['todayCancelled'] ?></small>
                    <small style="opacity: 0.8; display: block; margin-top: 5px;">Click to manage rides</small>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <div class="stat-card" style="background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);">
                <div class="icon"><i class="fa fa-percentage"></i></div>
                <div class="value">
                    <?php 
                    $totalRides = $ridesStats['completed'] + $ridesStats['cancelled'];
                    $completionRate = $totalRides > 0 ? round(($ridesStats['completed'] / $totalRides) * 100, 1) : 0;
                    echo $completionRate . '%';
                    ?>
                </div>
                <div class="label">Completion Rate</div>
            </div>
        </div>
    </div>

    <!-- Global Balance -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Global Balance</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <h5>Total Earnings</h5>
                            <p class="balance-positive" style="font-size: 1.5rem;">$<?= number_format($balances['global']['totalEarnings'], 2) ?></p>
                        </div>
                        <div class="col-md-4">
                            <h5>Paid Amount</h5>
                            <p class="balance-positive" style="font-size: 1.5rem;">$<?= number_format($balances['global']['paidAmount'], 2) ?></p>
                        </div>
                        <div class="col-md-4">
                            <h5>Pending Amount</h5>
                            <p class="balance-pending" style="font-size: 1.5rem;">$<?= number_format($balances['global']['pendingAmount'], 2) ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Driver Performance -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Driver Performance</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered performance-table">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Driver Name</th>
                                    <th>Email</th>
                                    <th>Total Rides</th>
                                    <th>Completed</th>
                                    <th>Cancelled</th>
                                    <th>Total Revenue</th>
                                    <th>Average Rating</th>
                                    <th>Completion Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($driverPerformance)): ?>
                                    <?php foreach ($driverPerformance as $driverId => $performance): ?>
                                        <tr>
                                            <td><?= isset($performance['driverName']) ? htmlspecialchars($performance['driverName']) : 'Unknown' ?></td>
                                            <td><?= isset($performance['driverEmail']) ? htmlspecialchars($performance['driverEmail']) : '-' ?></td>
                                            <td><?= $performance['totalRides'] ?></td>
                                            <td><span class="badge badge-success"><?= $performance['completedRides'] ?></span></td>
                                            <td><span class="badge badge-danger"><?= $performance['cancelledRides'] ?></span></td>
                                            <td>$<?= number_format($performance['totalRevenue'], 2) ?></td>
                                            <td>
                                                <?php if ($performance['averageRating'] > 0): ?>
                                                    <span class="badge-rating"><?= $performance['averageRating'] ?> ⭐</span>
                                                <?php else: ?>
                                                    <span class="badge badge-secondary">N/A</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php 
                                                $totalRides = $performance['totalRides'];
                                                $rate = $totalRides > 0 ? round(($performance['completedRides'] / $totalRides) * 100, 1) : 0;
                                                ?>
                                                <span class="badge badge-info"><?= $rate ?>%</span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="8" class="text-center">No driver performance data available</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Individual Driver Balances -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Individual Driver Balances</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Driver Name</th>
                                    <th>Email</th>
                                    <th>Total Earnings</th>
                                    <th>Paid Amount</th>
                                    <th>Pending Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($balances['drivers'])): ?>
                                    <?php foreach ($balances['drivers'] as $driverId => $balance): ?>
                                        <tr>
                                            <td><?= isset($balance['driverName']) ? htmlspecialchars($balance['driverName']) : 'Unknown' ?></td>
                                            <td><?= isset($balance['driverEmail']) ? htmlspecialchars($balance['driverEmail']) : '-' ?></td>
                                            <td class="balance-positive">$<?= number_format($balance['totalEarnings'], 2) ?></td>
                                            <td class="balance-positive">$<?= number_format($balance['paidAmount'], 2) ?></td>
                                            <td class="balance-pending">$<?= number_format($balance['pendingAmount'], 2) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No driver balance data available</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment History -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Internal Payments History</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Payment ID</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($paymentHistory)): ?>
                                    <?php foreach ($paymentHistory as $payment): ?>
                                        <tr>
                                            <td><?= isset($payment['paymentId']) ? htmlspecialchars($payment['paymentId']) : '-' ?></td>
                                            <td>
                                                <?php 
                                                if (isset($payment['timestamp'])) {
                                                    $timestamp = is_numeric($payment['timestamp']) ? $payment['timestamp'] / 1000 : strtotime($payment['timestamp']);
                                                    echo date('Y-m-d H:i:s', $timestamp);
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td class="balance-positive">$<?= isset($payment['amount']) ? number_format((float)$payment['amount'], 2) : '0.00' ?></td>
                                            <td>
                                                <?php 
                                                $status = isset($payment['status']) ? $payment['status'] : 'pending';
                                                $badgeClass = $status == 'paid' ? 'badge-success' : ($status == 'pending' ? 'badge-warning' : 'badge-danger');
                                                ?>
                                                <span class="badge <?= $badgeClass ?>"><?= ucfirst($status) ?></span>
                                            </td>
                                            <td><?= isset($payment['description']) ? htmlspecialchars($payment['description']) : '-' ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No payment history available</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Rides -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Rides</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Ride ID</th>
                                    <th>Date</th>
                                    <th>Pickup Location</th>
                                    <th>Drop Location</th>
                                    <th>Price</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($recentRides)): ?>
                                    <?php foreach ($recentRides as $ride): ?>
                                        <tr>
                                            <td><?= isset($ride['rideId']) ? substr(htmlspecialchars($ride['rideId']), 0, 10) . '...' : '-' ?></td>
                                            <td>
                                                <?php 
                                                if (isset($ride['bookingDate'])) {
                                                    $timestamp = is_numeric($ride['bookingDate']) ? $ride['bookingDate'] / 1000 : strtotime($ride['bookingDate']);
                                                    echo date('Y-m-d H:i:s', $timestamp);
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td><?= isset($ride['pickupLocation']) ? htmlspecialchars($ride['pickupLocation']) : (isset($ride['pickupAddress']) ? htmlspecialchars($ride['pickupAddress']) : '-') ?></td>
                                            <td><?= isset($ride['dropLocation']) ? htmlspecialchars($ride['dropLocation']) : (isset($ride['dropAddress']) ? htmlspecialchars($ride['dropAddress']) : '-') ?></td>
                                            <td>$<?= isset($ride['price']) ? number_format((float)$ride['price'], 2) : '0.00' ?></td>
                                            <td>
                                                <?php 
                                                $status = isset($ride['status']) ? $ride['status'] : 'unknown';
                                                $badgeClass = 'badge-secondary';
                                                if ($status == 'rideCompleted') $badgeClass = 'badge-success';
                                                elseif ($status == 'cancelled') $badgeClass = 'badge-danger';
                                                elseif ($status == 'rideStarted') $badgeClass = 'badge-info';
                                                elseif ($status == 'booked') $badgeClass = 'badge-warning';
                                                ?>
                                                <span class="badge <?= $badgeClass ?>"><?= ucfirst(str_replace('ride', '', $status)) ?></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No recent rides available</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-refresh dashboard every 5 minutes
setTimeout(function() {
    location.reload();
}, 300000); // 5 minutes
</script>

