<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
<style>
    .status-badge {
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 0.85rem;
    }
    .badge-completed { background-color: #28a745; color: white; }
    .badge-cancelled { background-color: #dc3545; color: white; }
    .badge-ongoing { background-color: #17a2b8; color: white; }
    .badge-booked { background-color: #ffc107; color: #000; }
    .badge-arriving { background-color: #fd7e14; color: white; }
</style>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Fleet Rides Management</h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Total Rides: <?= $rideCount ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered" id="ridesTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Date/Time</th>
                            <th>Customer</th>
                            <th>Driver</th>
                            <th>Pickup Location</th>
                            <th>Drop Location</th>
                            <th>Distance</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($rides)): ?>
                            <?php foreach ($rides as $ride): ?>
                                <tr>
                                    <td>
                                        <?php 
                                        if (isset($ride['bookingDate'])) {
                                            $timestamp = is_numeric($ride['bookingDate']) ? $ride['bookingDate'] / 1000 : strtotime($ride['bookingDate']);
                                            echo date('Y-m-d H:i:s', $timestamp);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if (isset($ride['user'])) {
                                            $user = $ride['user'];
                                            $userName = '';
                                            if (isset($user['fullName'])) {
                                                $userName = $user['fullName'];
                                            } elseif (isset($user['firstName'])) {
                                                $userName = $user['firstName'];
                                                if (isset($user['lastName'])) {
                                                    $userName .= ' ' . $user['lastName'];
                                                }
                                            }
                                            echo htmlspecialchars($userName ?: 'Unknown');
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if (isset($ride['driver'])) {
                                            $driver = $ride['driver'];
                                            $driverName = '';
                                            if (isset($driver['fullName'])) {
                                                $driverName = $driver['fullName'];
                                            } elseif (isset($driver['firstName'])) {
                                                $driverName = $driver['firstName'];
                                                if (isset($driver['lastName'])) {
                                                    $driverName .= ' ' . $driver['lastName'];
                                                }
                                            }
                                            echo htmlspecialchars($driverName ?: 'Unknown');
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $pickup = '-';
                                        if (isset($ride['pickupLocation'])) {
                                            $pickup = $ride['pickupLocation'];
                                        } elseif (isset($ride['pickupAddress'])) {
                                            $pickup = $ride['pickupAddress'];
                                        } elseif (isset($ride['pickup'])) {
                                            $pickup = is_array($ride['pickup']) ? (isset($ride['pickup']['address']) ? $ride['pickup']['address'] : '-') : $ride['pickup'];
                                        }
                                        echo htmlspecialchars($pickup);
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $drop = '-';
                                        if (isset($ride['dropLocation'])) {
                                            $drop = $ride['dropLocation'];
                                        } elseif (isset($ride['dropAddress'])) {
                                            $drop = $ride['dropAddress'];
                                        } elseif (isset($ride['drop'])) {
                                            $drop = is_array($ride['drop']) ? (isset($ride['drop']['address']) ? $ride['drop']['address'] : '-') : $ride['drop'];
                                        }
                                        echo htmlspecialchars($drop);
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if (isset($ride['distance'])) {
                                            echo number_format((float)$ride['distance'], 2) . ' km';
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if (isset($ride['price'])) {
                                            echo '$' . number_format((float)$ride['price'], 2);
                                        } elseif (isset($ride['rent'])) {
                                            echo '$' . number_format((float)$ride['rent'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $status = isset($ride['status']) ? $ride['status'] : 'unknown';
                                        $badgeClass = 'badge-secondary';
                                        $statusText = ucfirst($status);
                                        
                                        switch ($status) {
                                            case 'rideCompleted':
                                                $badgeClass = 'badge-completed';
                                                $statusText = 'Completed';
                                                break;
                                            case 'cancelled':
                                                $badgeClass = 'badge-cancelled';
                                                $statusText = 'Cancelled';
                                                break;
                                            case 'rideStarted':
                                                $badgeClass = 'badge-ongoing';
                                                $statusText = 'Ongoing';
                                                break;
                                            case 'booked':
                                                $badgeClass = 'badge-booked';
                                                $statusText = 'Booked';
                                                break;
                                            case 'driverAccepted':
                                                $badgeClass = 'badge-arriving';
                                                $statusText = 'Driver Arriving';
                                                break;
                                            case 'driverDriverReached':
                                                $badgeClass = 'badge-arriving';
                                                $statusText = 'Driver Arrived';
                                                break;
                                        }
                                        ?>
                                        <span class="status-badge <?= $badgeClass ?>"><?= $statusText ?></span>
                                    </td>
                                    <td>
                                        <?php if (isset($ride['rideId'])): ?>
                                            <button class="btn btn-info btn-sm" onclick="viewRideDetails('<?= $ride['rideId'] ?>')">
                                                <i class="fa fa-eye"></i> View
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">No rides found for this fleet</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Ride Details Modal -->
<div class="modal fade" id="rideDetailsModal" tabindex="-1" aria-labelledby="rideDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="rideDetailsModalLabel">Ride Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="rideDetailsContent">
                <!-- Ride details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('#ridesTable').DataTable({
        "order": [[0, "desc"]],
        "pageLength": 25
    });
});

function viewRideDetails(rideId) {
    // You can implement AJAX call to get detailed ride information
    $('#rideDetailsContent').html('<p>Loading ride details...</p>');
    $('#rideDetailsModal').modal('show');
    // TODO: Implement AJAX call to fetch detailed ride information
    // Example: $.get('<?= base_url("FleetOwnerDashboard/rideDetails/") ?>' + rideId, function(data) { ... });
}
</script>

