<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Log in - Serena Fleet Management</title>
    <!-- <link rel="icon" href="<?=base_url()?>assets/images/favicon.png" type="image/png" /> -->
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/fontawesome-free/css/all.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/dist/css/adminlte.min.css">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    
    <style>
        body.login-page {
            background: linear-gradient(135deg, #b5ebed 0%, #7dd3d6 50%, #5bc5c9 100%);
            background-attachment: fixed;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        body.login-page::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><defs><pattern id="grid" width="100" height="100" patternUnits="userSpaceOnUse"><path d="M 100 0 L 0 0 0 100" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="1"/></pattern></defs><rect width="100%" height="100%" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
            z-index: 0;
        }

        .login-box {
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
            animation: fadeInUp 0.6s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-box .card {
            border: none;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(10px);
        }

        .login-box .card-body {
            padding: 2.5rem;
        }

        .login-logo-container {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1.5rem;
            border-bottom: 2px solid #f0f0f0;
        }

        .login-logo-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #b5ebed 0%, #7dd3d6 50%, #5bc5c9 100%);
            border-radius: 16px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            box-shadow: 0 8px 20px rgba(181, 235, 237, 0.4);
        }

        .login-logo-icon i {
            font-size: 2rem;
            color: white;
        }

        .login-box-msg {
            margin: 0;
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            letter-spacing: -0.5px;
        }

        .login-subtitle {
            color: #718096;
            font-size: 0.9rem;
            margin-top: 0.5rem;
            font-weight: 400;
        }

        .form-group-custom {
            margin-bottom: 1.5rem;
        }

        .input-group {
            position: relative;
        }

        .input-group .form-control {
            height: 50px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            padding-left: 50px;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .input-group .form-control:focus {
            border-color: #b5ebed;
            background: #fff;
            box-shadow: 0 0 0 3px rgba(181, 235, 237, 0.2);
            outline: none;
        }

        .input-group-text {
            position: absolute;
            left: 0;
            top: 0;
            height: 50px;
            width: 50px;
            background: transparent;
            border: none;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #5bc5c9;
            font-size: 1.1rem;
        }

        .input-group-append {
            display: none;
        }

        .btn-login {
            height: 50px;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            background: linear-gradient(135deg, #b5ebed 0%, #7dd3d6 50%, #5bc5c9 100%);
            border: none;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(181, 235, 237, 0.4);
            text-transform: uppercase;
            color: #2d3748;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(181, 235, 237, 0.5);
            background: linear-gradient(135deg, #5bc5c9 0%, #7dd3d6 50%, #b5ebed 100%);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .alert {
            border-radius: 10px;
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-bottom: 1.5rem;
            animation: slideDown 0.3s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
        }

        .alert-warning {
            background: #fff3cd;
            color: #856404;
        }

        .footer-text {
            text-align: center;
            margin-top: 1.5rem;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.85rem;
        }

        .footer-text a {
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
        }

        .footer-text a:hover {
            color: #fff;
            text-decoration: underline;
        }

        @media (max-width: 576px) {
            .login-box {
                padding: 1rem;
            }

            .login-box .card-body {
                padding: 2rem 1.5rem;
            }

            .login-box-msg {
                font-size: 1.5rem;
            }
        }
    </style>
</head>

<body class="hold-transition login-page">
    <div class="login-box">
        <div class="row">
            <?php 
            $successMessage = $this->session->flashdata('successmessage');
            $warningmessage = $this->session->flashdata('warningmessage');
            if (isset($successMessage)) {
                echo '<div id="alertmessage" class="col-md-12">
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="fas fa-check-circle mr-2"></i>' . output($successMessage) . '
                    </div>
                </div>';
            }
            if (isset($warningmessage)) {
                echo '<div id="alertmessage" class="col-md-12">
                    <div class="alert alert-warning alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="fas fa-exclamation-triangle mr-2"></i>' . output($warningmessage) . '
                    </div>
                </div>';
            }
            ?>
        </div>

        <div class="card">
            <div class="card-body login-card-body">
                <div class="login-logo-container">
                    <div class="login-logo-icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="login-box-msg">Serena Fleet Management</h3>
                    <p class="login-subtitle">Sign in to access your dashboard</p>
                </div>

                <form action="<?= base_url() . 'login/login_action'; ?>" method="post" id="loginForm">
                    <div class="form-group-custom">
                        <div class="input-group">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                            <input type="email" name="email" required class="form-control" placeholder="Enter your email address" autocomplete="email">
                        </div>
                    </div>

                    <div class="form-group-custom">
                        <div class="input-group">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                            <input type="password" name="password" required class="form-control" placeholder="Enter your password" autocomplete="current-password">
                        </div>
                    </div>

                    <div class="form-group-custom">
                        <button type="submit" class="btn btn-primary btn-block btn-login">
                            <i class="fas fa-sign-in-alt mr-2"></i>Sign In
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="footer-text">
            <p>&copy; <?= date('Y'); ?> Serena Fleet Management. All rights reserved.</p>
        </div>
    </div>

    <!-- jQuery -->
    <script src="<?= base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="<?= base_url(); ?>assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Add focus animation to inputs
            $('.form-control').on('focus', function() {
                $(this).closest('.input-group').find('.input-group-text').css('color', '#3ba8ac');
            }).on('blur', function() {
                $(this).closest('.input-group').find('.input-group-text').css('color', '#5bc5c9');
            });

            // Form validation enhancement
            $('#loginForm').on('submit', function(e) {
                var email = $('input[name="email"]').val();
                var password = $('input[name="password"]').val();
                
                if (!email || !password) {
                    e.preventDefault();
                    return false;
                }
            });
        });
    </script>
</body>

</html>