<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
  
  public function codes()
  {
    $data["codes"] = $this->common->readdatafromcollectionbetween("Codes");
    
    $this->template->template_render('codes', $data);
  }

  

  public function generateCode()
  {
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $code = "";
    for ($i = 0; $i < 10; $i++) {
        $code .= $chars[mt_rand(0, strlen($chars)-1)];
    }
    $data["code"] = $code;
    $data["used"] = false;
    $response = $this->common->addnewdatamodel("Codes", $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'New Code has been generated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/codes'));
  }



  public function index()
  {
    $data['suspendedUsers'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'isActive', '=', false, "userRole", "=", "user");
    $data['activeUsers'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'isActive', '=', true, "userRole", "=", "user");
    $data['totalUsers'] = $this->common->readnumberofdocumentsincollectionbetween('Users', "userRole", "=", "user");
   
    $this->template->template_render('dashboard', $data);
  }



}