<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
   public function report()
  {
    $data["users"] = $this->common->readnumberofdocumentsincollectionbetween("report");
    $this->template->template_render('report', $data);
  }


  public function index()
  {
    $professions = $this->common->readdatafromcollectionbetween('Profession');
    $new = array();
    foreach($professions as $key => $profession) {
      $new[$profession['name']] = $key;
    }
    $data["users"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'userRole', '=', 'user');
    $data["artists"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'profession', 'array-contains', $new['Artist']);
    $data["producers"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'profession', 'array-contains', $new['Producer']);
    $data["instrumentalists"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'profession', 'array-contains', $new['Instrumentalist']);
    $data["songwriters"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'profession', 'array-contains', $new['Songwriter']);
    $data["professionals"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'profession', 'array-contains', $new['Industry Professional']);
    $data["podcasts"] = $this->common->readnumberofdocumentsincollectionbetween("Instrumentalist");
    $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://us-central1-songpad-59207.cloudfunctions.net/widgets/myanylatics',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);
$data['anaylatic'] =json_decode($response);

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://us-central1-songpad-59207.cloudfunctions.net/widgets/pageanylatics',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response1 = curl_exec($curl);

curl_close($curl);
$data['pageanaylatic'] =json_decode($response1);
// echo "<pre>";
// print_r($data['anaylatic'])
// echo "</pre>";
    $this->template->template_render('dashboard', $data);
  }



  public function iechart()
  {
    $data = $this->common->get_iechartdata();
    $res = "['" . implode("', '", array_keys($data)) . "']";
    $income = "['" . implode("', '", array_column($data, 'income')) . "']";
    $expense = "['" . implode("', '", array_column($data, 'expense')) . "']";
    echo json_encode(array('res' => $res, 'admin' => $income, 'driver' => $expense));
  }
  public function remindermark()
  {
    $data = array('r_isread' => 1);
    $this->db->where('r_id', $this->input->post('r_id'));
    echo $this->db->update('reminder', $data);
  }
}