<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Restserver\Libraries\REST_Controller;

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Partners extends REST_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load the partner_model
        $this->load->model('partner_model');
        // Load the form validation library
        $this->load->library('form_validation');
        // Configure the validation rules
        $this->form_validation->set_rules('id', 'Id', 'required');
    }

    public function index_get($id)
    {
        // Get a single partner by ID
        if ($id !== NULL) {
            $partner = $this->partner_model->get_partner($id);
            if ($partner) {
                $this->response($partner, REST_Controller::HTTP_OK);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => 'partner not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        } else {
            // Get all partners
            $partners = $this->partner_model->get_partners();
            $this->response($partners, REST_Controller::HTTP_OK);
        }
    }

    public function index_post()
    {
        // Create a new partner
        $data = $this->post();

        if ($this->form_validation->set_data($data) == FALSE) {
            $this->response([
                'status' => FALSE,
                'message' => validation_errors()
            ], REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $partner_id = $this->partner_model->create_partner($data);
            if ($partner_id) {
                $this->response([
                    'status' => TRUE,
                    'message' => 'partner created successfully',
                    'data' => ['partner_id' => $partner_id]
                ], REST_Controller::HTTP_CREATED);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => "Oops Something went wrong. Please try again."
                ], REST_Controller::HTTP_BAD_REQUEST);
            }
        }
        // $this->response([
        // 	'status' => TRUE,
        // 	'data' => ['data' => $password]
        // ]);
    }

    public function index_patch($id)
    {
        // Update an existing partner by ID
        $data = $this->patch();
        $updated = $this->partner_model->update_partner($id, $data);
        if ($updated) {
            $this->response([
                'status' => TRUE,
                'message' => 'partner updated successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Oops Something went wrong. Please try again.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function index_delete($id)
    {
        // Delete an existing partner by ID
        $deleted = $this->partner_model->delete_partner($id);
        if ($deleted) {
            $this->response([
                'status' => TRUE,
                'message' => 'partner deleted successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Failed to delete partner'
            ], REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
