<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use Google\Cloud\Firestore\FirestoreClient;

class User_model extends CI_Model
{
	public  function update_user_password($id, $pwd)
	{
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$auth = $firebase->createAuth();
		try {
			$updatedUser = $auth->changeUserPassword($id, $pwd);
			return True;
		} catch (\Throwable $th) {
			return False;
		}
	}

	public function get_users()
	{
		$x = $this->config->item('firebase_app_key');
		$firebaseProjectID = $this->config->item('firesbase_project_id');
		$db = new FirestoreClient([
			'projectId' => $firebaseProjectID,
			'keyFile' => json_decode(file_get_contents($x), true)
		]);

		$citiesRef = $db->collection('Users');
		$documents = $citiesRef->documents();
		$output = array();
		foreach ($documents as $document) {
			if ($document->exists()) {
				$path = substr($document->path(), 8);
				$output[$path] = $document->data();
			}
		}
		return $output;
	}

	public function get_user($c_id)
	{
		$x = $this->config->item('firebase_app_key');
		$firebaseProjectID = $this->config->item('firesbase_project_id');
		$db = new FirestoreClient([
			'projectId' => $firebaseProjectID,
			'keyFile' => json_decode(file_get_contents($x), true)
		]);
		$document = $db->collection('Users')->document($c_id)->snapshot()->data();

		return $document;
	}

	public function create_user($data)
	{
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();

		$auth = $firebase->createAuth();
		$userProperties = [
			'email' => $data['email'],
			'password' => $data['password']
		];

		try {
			$createdUser = $auth->createUser($userProperties);
		} catch (\Throwable $th) {
			return False;
		}
		$signInResult = $auth->signInWithEmailAndPassword($userProperties['email'], $userProperties['password']);
		$my = $signInResult->data();
		$data['id'] = $my['localId'];
		$data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);

		$x = $this->config->item('firebase_app_key');
		$firebaseProjectID = $this->config->item('firesbase_project_id');
		$firestore = new FirestoreClient([
			'projectId' => $firebaseProjectID,
			'keyFile' => json_decode(file_get_contents($x), true)
		]);
		$batch = $firestore->collection('Users')->document($my['localId']);
		$response = $batch->set($data);
		return $data;
	}



	public function update_user($id, $data)
	{
		$x = $this->config->item('firebase_app_key');
		$firebaseProjectID = $this->config->item('firesbase_project_id');
		$db = new FirestoreClient([
			'projectId' => $firebaseProjectID,
			'keyFile' => json_decode(file_get_contents($x), true)
		]);
		try {
			$customerData = array();
			foreach ($data as $key => $value) {
				$d['path'] = $key;
				$d['value'] = $value;
				array_push($customerData, $d);
			}
			$batch = $db->collection('Users')->document($id);
			$response = $batch->update($customerData);
		} catch (\Throwable $th) {
			return FALSE;
		}
		return TRUE;
	}

	public function delete_user($id)
	{
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$auth = $firebase->createAuth();
		try {
			$auth->deleteUser($id);
			$x = $this->config->item('firebase_app_key');
			$firebaseProjectID = $this->config->item('firesbase_project_id');
			$firestore = new FirestoreClient([
				'projectId' => $firebaseProjectID,
				'keyFile' => json_decode(file_get_contents($x), true)
			]);
			$firestore->collection('Users')->document($id)->delete();
		} catch (\Kreait\Firebase\Exception\Auth\UserNotFound $e) {
			return FALSE;
		} catch (\Kreait\Firebase\Exception\AuthException $e) {
			return FALSE;
		}
		return $id;
	}
}
