<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
   public function report()
  {
    $data["reports"] = $this->common->readdatafromcollectionbetween("Reports");
    foreach($data["reports"] as $key => $value){

      $data["reports"][$key]["reportedUser"] = $this->common->readdatadocument("Users", $value["reportedUserID"]);
      @$data["reports"][$key]["reportedUser"]['isDeleted'] = false;
      if(is_null($data["reports"][$key]["reportedUser"]) || empty($data["reports"][$key]["reportedUser"])) {
        $data["reports"][$key]["reportedUser"] = $this->common->readdatadocument("DeletedUser", $value['reportedUserID']);
        @$data["reports"][$key]["reportedUser"]['isDeleted'] = true;
      }
      $data["reports"][$key]["reportedFrom"] = $this->common->readdatadocument("Users", $value["userId"]);
      @$data["reports"][$key]["reportedFrom"]['isDeleted'] = false;
      if(is_null($data["reports"][$key]["reportedFrom"]) || empty($data["reports"][$key]["reportedFrom"])) {
        $data["reports"][$key]["reportedFrom"] = $this->common->readdatadocument("DeletedUser", $value['userId']);
        @$data["reports"][$key]["reportedFrom"]['isDeleted'] = false;
      }
      $reportData['isRead'] = true;
      $this->common->updatedatamodel("Reports", $key, $reportData);
    }
    $this->template->template_render('report', $data);
  }

  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }
  function addsports(){

   $post = $this->input->post();
$id=time();
    $response = $this->common->adddatamodel("sports", $id, $post);
    if($response) {
        $this->session->set_flashdata('successmessage', 'Data has been updated');
    }else{
      $this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/sports')); 
  }
function revenue(){
    $this->template->template_render('report', $data);
}
//revenue
function categroy(){
    $this->template->template_render('categroy', $data);
}
function addcategroy(){
    $this->template->template_render('addcategroy', $data);
}

//products
function products(){
    $this->template->template_render('products_management', $data);
}
//addpoduct
function addpoduct(){
    $this->template->template_render('addpoduct', $data);
}
//addpromotion
function addpromotion(){
    $this->template->template_render('addpromotion', $data);
}
//
function addevent(){
    $this->template->template_render('addevent', $data);
}
//
function service(){
    $this->template->template_render('service', $data);
}
//
function addservices(){
    $this->template->template_render('addservices', $data);
}
//event
function event(){
    $this->template->template_render('event', $data);
}
//drivers_management
  public function sports()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("sports");
    // echo "<pre>";
    // print_r($data);
    // echo "</pre>";
    
    $this->template->template_render('sports', $data);
  }

public function deletesports($id){
    $response = $this->common->deletedatamodel("sports", $id);
    if($response) {
        $this->session->set_flashdata('successmessage', 'Data has been Removed');
    }else{
      $this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/sports'));
 
}

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Data has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $professions = $this->common->readdatafromcollectionbetween('Dates');
    $data['DateCount']=count($professions);
    $professions = $this->common->readdatafromcollectionbetween('Notes');
    $data['NotesCount']=count($professions);
    $users = $this->common->readdatafromcollectionwhereclause("Users", 'userRole', '=', 'user');
    $data['users']=count($users);
      foreach ($users as $key => $user) {
        $timestamps[$key]    = $user['userDate'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStr'] = $dataStr;


    // echo "<pre>";
    // print_r($data['pageanaylatic']);
    // echo "</pre>";
   
    $this->template->template_render('dashboard', $data);
  }



  public function iechart()
  {
    $data = $this->common->get_iechartdata();
    $res = "['" . implode("', '", array_keys($data)) . "']";
    $income = "['" . implode("', '", array_column($data, 'income')) . "']";
    $expense = "['" . implode("', '", array_column($data, 'expense')) . "']";
    echo json_encode(array('res' => $res, 'admin' => $income, 'driver' => $expense));
  }
  public function remindermark()
  {
    $data = array('r_isread' => 1);
    $this->db->where('r_id', $this->input->post('r_id'));
    echo $this->db->update('reminder', $data);
  }
}