  <!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">
            <button class="btn guestBtn d-flex gap-2 align-items-center" id="backBtn"><img
                    src="<?php echo base_url(); ?>assets/images/arowleft.svg" alt="" width="15px"> Back</button>
            <div class="row">
                <div class="col-md-8 my-2">
                    <h3 class="fmon fw-bold"><i class="fa fa-plus"></i> Create Check List </h3>
                </div>

            </div>
            <div class="modal-body">



                <form class="row" id="checkForm" action="<?php echo base_url('site/addchecklist'); ?>" method="post">
                    <!-- Title Field -->
                    <div class="col-md-12 my-2">
                        <input type="text" name="title" id="title" required class="form-control FormInput" placeholder="Title">
                    </div>

                    <!-- Frequency Dropdown -->
                    <div class="col-md-6 my-2 align-self-end">
                        <select name="frequency" id="frequency" class="form-select Formselet"
                            onchange="toggleDateFields()" required>
                            <option value="" selected>Select Frequency</option>
                            <option value="daily">Daily</option>
                            <option value="weekly">Weekly</option>
                            <option value="monthly">Monthly</option>
                            <option value="hourly">Hourly</option>
                        </select>
                    </div>

                    <!-- Start Date and Finish Date -->
                    <div class="col-md-6 my-2 align-self-end" id="startDateDiv" style="display: none;">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" id="start_date" required class="form-control FormInput"
                            placeholder="Start Date">
                    </div>
                    <div class="col-md-6 my-2 align-self-end" id="finishDateDiv" style="display: none;">
                        <label class="form-label">End Date</label>
                        <input type="date" name="finish_date" id="finish_date" required class="form-control FormInput"
                            placeholder="Finish Date">
                    </div>

                    <!-- Hourly - From Hour & To Hour -->
                    <div class="col-md-6 my-2 align-self-end" id="fromHourDiv" style="display: none;">
                        <label class="form-label">From (Hour)</label>
                        <input type="time" name="from_hour" id="from_hour" class="form-control FormInput"
                            placeholder="From Hour">
                    </div>
                    <div class="col-md-6 my-2 align-self-end" id="toHourDiv" style="display: none;">
                        <label class="form-label">To(Hour)</label>
                        <input type="time" name="to_hour" id="to_hour" class="form-control FormInput"
                            placeholder="To Hour">
                    </div>

                    <!-- Area to Check Section -->
                    <div class="col-md-12 my-2" id="areas-container">
                        <div class="d-flex gap-3 align-items-center my-3">
                            <h5>Area to Check</h5> <button type="button" class="btn btn-success"
                                onclick="addArea()">+</button>
                        </div>
                        <div id="areas-list">
                            <div class="row area-row mb-3">
                                <div class="col-md-6">
                                    <input type="text" class="form-control me-2 FormInput" name="area[]"
                                        placeholder="Area Name">
                                </div>
                                <div class="col-md-6 d-flex align-items-center">
                                    <button type="button" class="btn btn-success me-1"
                                        onclick="addArea()">+</button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="deleteArea(this)" style="display: none;">-</button>
                                </div>
                                <div class="row justify-content-end mt-2">
                                    <div class="col-md-11">
                                        <div class="area-check-container" data-area-index="0">

                                            <div class="d-flex align-items-center mb-2 instruction-row">
                                                <input type="text" class="form-control me-2 FormInput" name="instruction[]"
                                                    placeholder="Enter instruction">
                                                <input type="hidden" name="area_index[]" value="0">
                                                <button type="button" class="btn btn-success me-1"
                                                    onclick="addInstruction()">+</button>
                                                <button type="button" class="btn btn-danger"
                                                    onclick="deleteInstruction(this)" style="display: none;">-</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Common Areas Check -->
                    <!-- <div class="col-md-12 my-2">
                        <h5>Common Areas Check</h5>
                        <div id="common-areas-container">
                            <div class="d-flex align-items-center mb-2">
                                <input type="text" class="form-control me-2 FormInput" name="common_area[]"
                                    placeholder="Enter area">
                                <button type="button" class="btn btn-success" onclick="addCommonArea()">+</button>
                            </div>
                        </div>
                    </div> -->
                    <div class="col-m-12 my-2">
                        <h5>Upload Image</h5>
                        <div class="brower2 d-flex justify-content-center align-items-center">
                            <div class="d-flex flex-column align-items-center">
                                <img src="<?php echo base_url(); ?>assets/images/up2.png" alt="" width="20px">
                                <small>Drage and Drop here or <label for="file" class="text-primary"
                                        style="cursor: pointer;">Browse Files</label></small>
                                <input class="d-none" type="image" name="file" id="file">
                            </div>
                        </div>
                    </div>
                    <!-- Submit Button -->
                    <div class="col-md-12 my-2 text-center">
                        <button type="submit" class="btn guestBtn px-5">Submit</button>
                    </div>
                </form>
                <!-- button for attahmnts -->



            </div>
        </div>
        </div>

    </main>
    <!--end main wrapper-->

    <script>
         function toggleDateFields() {
            let frequency = document.getElementById("frequency").value;
            let startDateDiv = document.getElementById("startDateDiv");
            let finishDateDiv = document.getElementById("finishDateDiv");
            let fromHourDiv = document.getElementById("fromHourDiv");
            let toHourDiv = document.getElementById("toHourDiv");

            if (frequency === "daily" || frequency === "weekly" || frequency === "monthly") {
                startDateDiv.style.display = "block";
                finishDateDiv.style.display = "block";
                fromHourDiv.style.display = "none";
                toHourDiv.style.display = "none";
            } else if (frequency === "hourly") {
                startDateDiv.style.display = "block";
                finishDateDiv.style.display = "block";
                fromHourDiv.style.display = "block";
                toHourDiv.style.display = "block";
            } else {
                startDateDiv.style.display = "none";
                finishDateDiv.style.display = "none";
                fromHourDiv.style.display = "none";
                toHourDiv.style.display = "none";
            }
        }

        // Function to add new instruction field
        function addInstruction() {
            // Find the closest area-check-container to the button that was clicked
            const button = event.target;
            const container = button.closest('.area-check-container');
            const areaIndex = container.getAttribute('data-area-index');
            
            const newRow = document.createElement('div');
            newRow.className = 'd-flex align-items-center mb-2 instruction-row';
            
            newRow.innerHTML = `
                <input type="text" class="form-control me-2 FormInput" name="instruction[]" placeholder="Enter instruction">
                <input type="hidden" name="area_index[]" value="${areaIndex}">
                <button type="button" class="btn btn-success me-1" onclick="addInstruction()">+</button>
                <button type="button" class="btn btn-danger" onclick="deleteInstruction(this)">-</button>
            `;
            
            container.appendChild(newRow);
            
            // Show delete button for all rows except the first one in this specific container
            updateDeleteButtonsInContainer(container);
        }
        
        // Function to delete instruction field
        function deleteInstruction(button) {
            const row = button.closest('.instruction-row');
            const container = row.closest('.area-check-container');
            row.remove();
            
            // Update delete buttons visibility in this specific container
            updateDeleteButtonsInContainer(container);
        }
        
        // Function to update delete buttons visibility in a specific container
        function updateDeleteButtonsInContainer(container) {
            const deleteButtons = container.querySelectorAll('.instruction-row .btn-danger');
            
            // Show delete button for all rows except the first one
            deleteButtons.forEach((button, index) => {
                if (index === 0) {
                    button.style.display = 'none';
                } else {
                    button.style.display = 'inline-block';
                }
            });
        }
        
        // Function to update delete buttons visibility (for all containers)
        function updateDeleteButtons() {
            const containers = document.querySelectorAll('.area-check-container');
            containers.forEach(container => {
                updateDeleteButtonsInContainer(container);
            });
        }
        
        // Initialize delete buttons on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateDeleteButtons();
            updateAreaDeleteButtons();
        });
        
        // Function to add new area field
        function addArea() {
            const container = document.getElementById('areas-list');
            const newArea = document.createElement('div');
            newArea.className = 'row area-row mb-3';
            
            // Get the current area index
            const currentAreaIndex = document.querySelectorAll('.area-row').length;
            
            newArea.innerHTML = `
                <div class="col-md-6">
                    <input type="text" class="form-control me-2 FormInput" name="area[]" placeholder="Area Name">
                </div>
                <div class="col-md-6 d-flex align-items-center">
                    <button type="button" class="btn btn-success me-1" onclick="addArea()">+</button>
                    <button type="button" class="btn btn-danger" onclick="deleteArea(this)">-</button>
                </div>
                <div class="row justify-content-end mt-2">
                    <div class="col-md-11">
                        <div class="area-check-container" data-area-index="${currentAreaIndex}">
                            <div class="d-flex align-items-center mb-2 instruction-row">
                                <input type="text" class="form-control me-2 FormInput" name="instruction[]" placeholder="Enter instruction">
                                <input type="hidden" name="area_index[]" value="${currentAreaIndex}">
                                <button type="button" class="btn btn-success me-1" onclick="addInstruction()">+</button>
                                <button type="button" class="btn btn-danger" onclick="deleteInstruction(this)" style="display: none;">-</button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            
            container.appendChild(newArea);
            
            // Update area delete buttons visibility
            updateAreaDeleteButtons();
        }
        
        // Function to delete area field
        function deleteArea(button) {
            const areaRow = button.closest('.area-row');
            areaRow.remove();
            
            // Update area delete buttons visibility
            updateAreaDeleteButtons();
        }
        
        // Function to update area delete buttons visibility
        function updateAreaDeleteButtons() {
            const areaRows = document.querySelectorAll('.area-row');
            const areaDeleteButtons = document.querySelectorAll('.area-row .btn-danger');
            
            // Show delete button for all area rows except the first one
            areaDeleteButtons.forEach((button, index) => {
                if (index === 0) {
                    button.style.display = 'none';
                } else {
                    button.style.display = 'inline-block';
                }
            });
        }
    </script>