<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Get all departments and roles structure
 */
if (!function_exists('get_department_structure')) {
    function get_department_structure() {
        return array(
            'admin' => array(
                'name' => 'Admin Panel',
                'icon' => 'shield-fill-check',
                'color' => 'danger',
                'roles' => array(
                    'admin_panel_manager' => 'Admin Panel Manager',
                    'hr_operations_officer' => 'HR Operations Officer',
                    'panel_access_coordinator' => 'Panel Access Coordinator'
                )
            ),
            'content' => array(
                'name' => 'Media Panel',
                'icon' => 'camera-video',
                'color' => 'primary',
                'roles' => array(
                    'media_panel_manager' => 'Media Panel Manager',
                    'content_strategist' => 'Content Strategist',
                    'promotion_specialist' => 'Promotion Specialist',
                    'verification_officer' => 'Verification Officer'
                )
            ),
            'userdepartment' => array(
                'name' => 'User Panel',
                'icon' => 'people-fill',
                'color' => 'info',
                'roles' => array(
                    'user_panel_manager' => 'User Panel Manager',
                    'user_accounts_officer' => 'User Accounts Officer',
                    'reports_analyst' => 'Reports Analyst',
                    'compliance_warnings_officer' => 'Compliance & Warnings Officer'
                )
            ),
            'accountant' => array(
                'name' => 'Finance Panel',
                'icon' => 'currency-dollar',
                'color' => 'success',
                'roles' => array(
                    'finance_panel_manager' => 'Finance Panel Manager',
                    'revenue_analyst' => 'Revenue Analyst',
                    'virtual_economy_specialist' => 'Virtual Economy Specialist',
                    'transaction_auditor' => 'Transaction Auditor'
                )
            )
        );
    }
}

/**
 * Get role information
 */
if (!function_exists('get_role_info')) {
    function get_role_info($roleKey) {
        $departments = get_department_structure();
        
        foreach ($departments as $deptKey => $dept) {
            if (isset($dept['roles'][$roleKey])) {
                return array(
                    'title' => $dept['roles'][$roleKey],
                    'department' => $dept['name'],
                    'departmentKey' => $deptKey,
                    'icon' => $dept['icon'],
                    'color' => $dept['color']
                );
            }
        }
        
        return array(
            'title' => ucfirst(str_replace('_', ' ', $roleKey)),
            'department' => 'Unknown',
            'departmentKey' => '',
            'icon' => 'person',
            'color' => 'secondary'
        );
    }
}

/**
 * Get department information
 */
if (!function_exists('get_department_info')) {
    function get_department_info($deptKey) {
        $departments = get_department_structure();
        
        if (isset($departments[$deptKey])) {
            return $departments[$deptKey];
        }
        
        return array(
            'name' => 'Unknown',
            'icon' => 'question-circle',
            'color' => 'secondary',
            'roles' => array()
        );
    }
}

/**
 * Get all roles as flat array
 */
if (!function_exists('get_all_roles')) {
    function get_all_roles() {
        $departments = get_department_structure();
        $allRoles = array();
        
        foreach ($departments as $deptKey => $dept) {
            foreach ($dept['roles'] as $roleKey => $roleTitle) {
                $allRoles[$roleKey] = array(
                    'title' => $roleTitle,
                    'department' => $dept['name'],
                    'departmentKey' => $deptKey,
                    'icon' => $dept['icon'],
                    'color' => $dept['color']
                );
            }
        }
        
        return $allRoles;
    }
}

