<?php defined ( 'BASEPATH' ) or exit ( 'No direct script access allowed' ); 

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Kishor Mali
 * @version : 1.1
 * @since : 15 November 2016
 */
class BaseController extends CI_Controller {
	protected $role = '';
	protected $vendorId = '';
	protected $name = '';
	protected $roleText = '';
	protected $isAdmin = 0;
	protected $accessInfo = [];
	protected $global = array ();
	protected $lastLogin = '';
	protected $module = '';

	/**
	 * This is default constructor
	 */
	public function __construct() {
		parent::__construct();
	}

	
	/**
	 * This function used to check the user is logged in or not
	 */
	function isLoggedIn() {
		return true;
	}
	
	/**
	 * This function is used to check the access
	 */
	function isAdmin() {
		return true;
		if ($this->session->userdata ( 'isLoggedIn' )) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * This function is used to check the user having list access or not
	 */
	protected function hasListAccess() {
		return true;
	}

	/**
	 * This function is used to check the user having create access or not
	 */
	protected function hasCreateAccess() {
		return true;
	}

	/**
	 * This function is used to check the user having update access or not
	 */
	protected function hasUpdateAccess() {
		return true;
	}

	/**
	 * This function is used to check the user having delete access or not
	 */
	protected function hasDeleteAccess() {
		return true;
	}

	/**
	 * Check if current user has access to a specific module
	 * @param string $module - Module name (promotions, gifts, transactions, revenue, etc.)
	 * @return boolean
	 */
	protected function hasModuleAccess($module) {
		// Get current admin user from session
		$adminId = $this->session->userdata('adminId');
		
		if (empty($adminId)) {
			return false;
		}
		
		// Get admin info from session or database
		$adminRole = $this->session->userdata('adminRole');
		$permissions = $this->session->userdata('adminPermissions');
		
		// Admin role has all access
		if ($adminRole === 'admin') {
			return true;
		}
		
		// Check specific permissions
		if (isset($permissions[$module]) && $permissions[$module] === true) {
			return true;
		}
		
		return false;
	}

	/**
	 * Check if user is Content Manager
	 */
	protected function isContentManager() {
		$adminRole = $this->session->userdata('adminRole');
		return ($adminRole === 'content' || $adminRole === 'admin');
	}

	/**
	 * Check if user is Accountant
	 */
	protected function isAccountant() {
		$adminRole = $this->session->userdata('adminRole');
		return ($adminRole === 'accountant' || $adminRole === 'admin');
	}

	/**
	 * Check if user can access promotions
	 */
	protected function canAccessPromotions() {
		return $this->hasModuleAccess('promotions');
	}

	/**
	 * Check if user can access gifts
	 */
	protected function canAccessGifts() {
		return $this->hasModuleAccess('gifts');
	}

	/**
	 * Check if user can access transactions
	 */
	protected function canAccessTransactions() {
		return $this->hasModuleAccess('transactions');
	}

	/**
	 * Check if user can access revenue
	 */
	protected function canAccessRevenue() {
		return $this->hasModuleAccess('revenue');
	}

	/**
	 * This function is used to load the set of views
	 */
	function loadThis() {
		$this->global ['pageTitle'] = 'CodeInsect : Access Denied';
		
		$this->load->view ( 'includes/header', $this->global );
		$this->load->view ( 'general/access' );
		$this->load->view ( 'includes/footer' );
	}
	
	/**
	 * This function is used to logged out user from system
	 */
	function logout() {
		$this->session->sess_destroy ();
		redirect ( 'login' );
	}

	/**
     * This function used to load views
     * @param {string} $viewName : This is view name
     * @param {mixed} $headerInfo : This is array of header information
     * @param {mixed} $pageInfo : This is array of page information
     * @param {mixed} $footerInfo : This is array of footer information
     * @return {null} $result : null
     */
//     function loadViews($viewName = "", $headerInfo = NULL, $pageInfo = NULL, $footerInfo = NULL){
// 		// pre($this->global); die;
//         $this->load->view('header', $headerInfo);
//         $this->load->view($viewName, $pageInfo);
//         $this->load->view('footer', $footerInfo);
//     }

// 	function loadViews($viewName = "", $headerInfo = NULL, $pageInfo = NULL, $footerInfo = NULL)
// 	{
// 		$userId = $this->session->userdata('userId');

// 		$userData = $this->user_model->getUserInfo($userId);

// 		// Merge the user data with header info
// 		if ($headerInfo === NULL) {
// 			$headerInfo = array();
// 		}

// 		$headerInfo['user'] = $userData;
// 		// print_r($headerInfo);
// 		// die;

// 		// Load the views
// 		$this->load->view('header', $headerInfo);
// 		$this->load->view($viewName, $pageInfo);
// 		$this->load->view('footer', $footerInfo);
// 	}


	function loadViews($viewName = "", $headerInfo = NULL, $pageInfo = NULL, $footerInfo = NULL)
	{
	//	$userId = $this->session->userdata('userId');

	//	$userData = $this->user_model->getUserInfo($userId);

		// Fetch notifications
	//	$this->load->model('user_model');
	//	$notifications = $this->user_model->getUnreadMessages($userId);

		// Merge the user data and notifications with header info
		if ($headerInfo === NULL) {
			$headerInfo = array();
		}

	//	$headerInfo['user'] = $userData;
//		$headerInfo['notifications'] = $notifications;

		// Load the views
		$this->load->view('header', $headerInfo);
		$this->load->view($viewName, $pageInfo);
		$this->load->view('footer', $footerInfo);
	}
	
	/**
	 * This function used provide the pagination resources
	 * @param {string} $link : This is page link
	 * @param {number} $count : This is page count
	 * @param {number} $perPage : This is records per page limit
	 * @return {mixed} $result : This is array of records and pagination data
	 */
	function paginationCompress($link, $count, $perPage = 10, $segment = SEGMENT) {
		$this->load->library ( 'pagination' );

		$config ['base_url'] = base_url () . $link;
		$config ['total_rows'] = $count;
		$config ['uri_segment'] = $segment;
		$config ['per_page'] = $perPage;
		$config ['num_links'] = 5;
		$config ['full_tag_open'] = '<nav><ul class="pagination">';
		$config ['full_tag_close'] = '</ul></nav>';
		$config ['first_tag_open'] = '<li class="arrow">';
		$config ['first_link'] = 'First';
		$config ['first_tag_close'] = '</li>';
		$config ['prev_link'] = 'Previous';
		$config ['prev_tag_open'] = '<li class="arrow">';
		$config ['prev_tag_close'] = '</li>';
		$config ['next_link'] = 'Next';
		$config ['next_tag_open'] = '<li class="arrow">';
		$config ['next_tag_close'] = '</li>';
		$config ['cur_tag_open'] = '<li class="active"><a href="#">';
		$config ['cur_tag_close'] = '</a></li>';
		$config ['num_tag_open'] = '<li>';
		$config ['num_tag_close'] = '</li>';
		$config ['last_tag_open'] = '<li class="arrow">';
		$config ['last_link'] = 'Last';
		$config ['last_tag_close'] = '</li>';
	
		$this->pagination->initialize ( $config );
		$page = $config ['per_page'];
		$segment = $this->uri->segment ( $segment );
	
		return array (
			"page" => $page,
			"segment" => $segment
		);
	}
}