<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use Google\Cloud\Firestore\FirestoreClient;

class Announcement_model extends CI_Model
{
    /**
     * Get all announcements
     */
    public function getall_announcements()
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        $citiesRef = $db->collection('Announcements');
        $documents = $citiesRef->documents();
        $output = array();
        
        foreach ($documents as $document) {
            if ($document->exists()) {
                $path = $document->id();
                $output[$path] = $document->data();
            }
        }
        
        return $output;
    }

    /**
     * Get single announcement
     */
    public function get_announcement($announcementId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);
        
        try {
            $document = $db->collection('Announcements')->document($announcementId)->snapshot()->data();
            return $document;
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * Add new announcement
     */
    public function add_announcement($data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            // Auto-generate document ID
            $docRef = $db->collection('Announcements')->newDocument();
            $docRef->set($data);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to add announcement: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Update announcement
     */
    public function update_announcement($announcementId, $data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $customerData = array();
            foreach ($data as $key => $value) {
                $d['path'] = $key;
                $d['value'] = $value;
                array_push($customerData, $d);
            }

            $docRef = $db->collection('Announcements')->document($announcementId);
            $docRef->update($customerData);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to update announcement: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Delete announcement
     */
    public function delete_announcement($announcementId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $docRef = $db->collection('Announcements')->document($announcementId);
            $docRef->delete();
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to delete announcement: ' . $e->getMessage());
            return false;
        }
    }
}

