<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use Google\Cloud\Firestore\FirestoreClient;

class Content_model extends CI_Model
{
    /**
     * Get all prioritized videos
     */
    public function getall_videos()
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        $citiesRef = $db->collection('PrioritizedVideo');
        $documents = $citiesRef->documents();
        $output = array();
        
        foreach ($documents as $document) {
            if ($document->exists()) {
                $path = $document->id();
                $output[$path] = $document->data();
            }
        }
        
        return $output;
    }

    /**
     * Get all advertisements
     */
    public function getall_advertisements()
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        $citiesRef = $db->collection('Advertisement');
        $documents = $citiesRef->documents();
        $output = array();
        
        foreach ($documents as $document) {
            if ($document->exists()) {
                $path = $document->id();
                $output[$path] = $document->data();
            }
        }
        
        return $output;
    }

    /**
     * Get single video
     */
    public function get_video($videoId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);
        
        try {
            $document = $db->collection('PrioritizedVideo')->document($videoId)->snapshot()->data();
            return $document;
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * Get single advertisement
     */
    public function get_advertisement($adId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);
        
        try {
            $document = $db->collection('Advertisement')->document($adId)->snapshot()->data();
            return $document;
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * Add new video
     */
    public function add_video($data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $docRef = $db->collection('PrioritizedVideo')->newDocument();
            $docRef->set($data);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to add video: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Add new advertisement
     */
    public function add_advertisement($data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $docRef = $db->collection('Advertisement')->newDocument();
            $docRef->set($data);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to add advertisement: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Update video
     */
    public function update_video($videoId, $data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $updateData = array();
            foreach ($data as $key => $value) {
                $d['path'] = $key;
                $d['value'] = $value;
                array_push($updateData, $d);
            }

            $docRef = $db->collection('PrioritizedVideo')->document($videoId);
            $docRef->update($updateData);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to update video: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Update advertisement
     */
    public function update_advertisement($adId, $data)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $updateData = array();
            foreach ($data as $key => $value) {
                $d['path'] = $key;
                $d['value'] = $value;
                array_push($updateData, $d);
            }

            $docRef = $db->collection('Advertisement')->document($adId);
            $docRef->update($updateData);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to update advertisement: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Delete video
     */
    public function delete_video($videoId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $docRef = $db->collection('PrioritizedVideo')->document($videoId);
            $docRef->delete();
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to delete video: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Delete advertisement
     */
    public function delete_advertisement($adId)
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $docRef = $db->collection('Advertisement')->document($adId);
            $docRef->delete();
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Failed to delete advertisement: ' . $e->getMessage());
            return false;
        }
    }
}

