<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

use Google\Cloud\Firestore\FirestoreClient;


class Gifts_model extends CI_Model
{
    private $factory;
    private $firestore;

    public function __construct()
    {
        parent::__construct();
        
        // Initialize Firebase
        $x=$this->config->item('firebase_app_key');
        $firestore = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' =>json_decode(file_get_contents($x), true)
          ]);

    
        $this->database = $firestore;
    }

    /**
     * Get all gifts from Gifts collection
     */
    public function get_all_gifts()
    {
        try {
            $giftsRef = $this->database->collection('Gifts');
            $documents = $giftsRef->documents();
            
            $gifts = array();
            foreach ($documents as $document) {
                if ($document->exists()) {
                    $gifts[$document->id()] = $document->data();
                }
            }
            
            // Sort by timestamp (newest first)
            uasort($gifts, function($a, $b) {
                $aTime = isset($a['timestamp']) ? $a['timestamp'] : 0;
                $bTime = isset($b['timestamp']) ? $b['timestamp'] : 0;
                return $bTime - $aTime;
            });
            
            return $gifts;
        } catch (Exception $e) {
            log_message('error', 'Error getting gifts: ' . $e->getMessage());
            return array();
        }
    }

    /**
     * Get gift by ID
     */
    public function get_gift_by_id($giftId)
    {
        try {
            $giftRef = $this->database->collection('Gifts')->document($giftId);
            $snapshot = $giftRef->snapshot();
            
            if ($snapshot->exists()) {
                return $snapshot->data();
            }
            
            return null;
        } catch (Exception $e) {
            log_message('error', 'Error getting gift: ' . $e->getMessage());
            return null;
        }
    }

    /**
     * Add new gift
     */
    public function add_gift($giftData)
    {
        try {
            $giftsRef = $this->database->collection('Gifts');
            $newGiftRef = $giftsRef->newDocument();
            $newGiftRef->set($giftData);
            
            return true;
        } catch (Exception $e) {
            log_message('error', 'Error adding gift: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Update gift
     */
    public function update_gift($giftId, $giftData)
    {
        try {
            $giftRef = $this->database->collection('Gifts')->document($giftId);
            $giftRef->update($giftData);
            
            return true;
        } catch (Exception $e) {
            log_message('error', 'Error updating gift: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Delete gift
     */
    public function delete_gift($giftId)
    {
        try {
            $giftRef = $this->database->collection('Gifts')->document($giftId);
            $giftRef->delete();
            
            return true;
        } catch (Exception $e) {
            log_message('error', 'Error deleting gift: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Get gift count
     */
    public function get_gift_count()
    {
        try {
            $gifts = $this->get_all_gifts();
            return count($gifts);
        } catch (Exception $e) {
            log_message('error', 'Error getting gift count: ' . $e->getMessage());
            return 0;
        }
    }
}

