<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use Google\Cloud\Firestore\FirestoreClient;

class Tick_model extends CI_Model
{
    /**
     * Get users with tick requests
     */
    public function get_tick_requests()
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $citiesRef = $db->collection('Users')->where('tickRequest', '=', true);
            $documents = $citiesRef->documents();
            $output = array();
            
            foreach ($documents as $document) {
                if ($document->exists()) {
                    $path = $document->id();
                    $output[$path] = $document->data();
                }
            }
            
            return $output;
        } catch (\Exception $e) {
            log_message('error', 'Failed to get tick requests: ' . $e->getMessage());
            return array();
        }
    }

    /**
     * Get verified users (those with blue tick)
     */
    public function get_verified_users()
    {
        $x = $this->config->item('firebase_app_key');
        $db = new FirestoreClient([
            'projectId' => 'stream-c7e91',
            'keyFile' => json_decode(file_get_contents($x), true)
        ]);

        try {
            $citiesRef = $db->collection('Users')->where('hasBlueCheck', '=', true);
            $documents = $citiesRef->documents();
            $output = array();
            
            foreach ($documents as $document) {
                if ($document->exists()) {
                    $path = $document->id();
                    $output[$path] = $document->data();
                }
            }
            
            return $output;
        } catch (\Exception $e) {
            log_message('error', 'Failed to get verified users: ' . $e->getMessage());
            return array();
        }
    }

    /**
     * Approve tick request
     */
    public function approve_tick($userId, $email)
    {
        $updateData = array(
            'old' => array('email' => $email),
            'new' => array(
                'hasBlueCheck' => true,
                'tickRequest' => false,
                'tickApprovedDate' => time() * 1000
            )
        );

        return $this->update_user_tick($updateData);
    }

    /**
     * Reject tick request
     */
    public function reject_tick($userId, $email, $reason = '')
    {
        $updateData = array(
            'old' => array('email' => $email),
            'new' => array(
                'tickRequest' => false,
                'tickRejectedDate' => time() * 1000,
                'tickRejectionReason' => $reason
            )
        );

        return $this->update_user_tick($updateData);
    }

    /**
     * Revoke blue tick
     */
    public function revoke_tick($userId, $email, $reason = '')
    {
        $updateData = array(
            'old' => array('email' => $email),
            'new' => array(
                'hasBlueCheck' => false,
                'tickRevokedDate' => time() * 1000,
                'tickRevocationReason' => $reason
            )
        );

        return $this->update_user_tick($updateData);
    }

    /**
     * Helper to update user tick data
     */
    private function update_user_tick($updateData)
    {
        $this->load->model('customer_model');
        return $this->customer_model->update_customer($updateData);
    }
}

