<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Add New Admin User</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('admin/admins'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Admin List
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">

        <form action="<?php echo base_url(); ?>admin/addNewAdmin" method="post" id="addAdminForm">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="fullName" class="form-label">Full Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="fullName" name="fullName" required>
              <?php if(function_exists('form_error') && form_error('fullName')): ?>
                <span class="text-danger"><?= form_error('fullName'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
              <input type="email" class="form-control" id="email" name="email" required>
              <?php if(function_exists('form_error') && form_error('email')): ?>
                <span class="text-danger"><?= form_error('email'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
              <input type="password" class="form-control" id="password" name="password" required minlength="6">
              <?php if(function_exists('form_error') && form_error('password')): ?>
                <span class="text-danger"><?= form_error('password'); ?></span>
              <?php endif; ?>
              <small class="text-muted">Minimum 6 characters</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="phone" class="form-label">Phone Number</label>
              <input type="text" class="form-control" id="phone" name="phone">
            </div>

            <div class="col-md-12 mb-3">
              <label for="role" class="form-label">Role <span class="text-danger">*</span></label>
              <select class="form-select" id="role" name="role" required>
                <option value="">Select Role</option>
                <option value="admin">👑 Admin Panel Department</option>
                <option value="content">📝 Media Panel Department</option>
                <option value="userdepartment">📱 User Panel Department</option>
                <option value="accountant">💰 Finance Panel Department</option>
              </select>
              <?php if(function_exists('form_error') && form_error('role')): ?>
                <span class="text-danger"><?= form_error('role'); ?></span>
              <?php endif; ?>
            </div>
          </div>

          <!-- Permissions Preview -->
          <div class="card mt-3" id="permissionsPreview" style="display: none;">
            <div class="card-header bg-light">
              <h6 class="mb-0"><i class="bi bi-key"></i> Role Permissions</h6>
            </div>
            <div class="card-body">
              <div id="permissionsList"></div>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Create Admin User
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script>
$(document).ready(function() {
    const rolePermissions = {
        'admin': {
            'Dashboard': true, 'Users': true, 'Customers': true, 'Announcements': true,
            'Promotions': true, 'Gifts': true, 'Transactions': true, 'Revenue': true,
            'Reports': true, 'Settings': true, 'HR Operations Officer': true, 'Role Management': true
        },
        'content': {
            'Dashboard': true, 'Promotions': true, 'Gifts': true, 'Content Strategist': true, 'Promotion Specialist': true, 'Verification Officer': true
        },
        'userdepartment': {
            'Dashboard': true, 'Users': true, 'Reports': true, 'Warnings': true, 'User Accounts Officer': true, 'Reports Analyst': true, 'Compliance & Warnings Officer': true
        },
        'accountant': {
            'Finance Panel Manager': true, 'Revenue Analyst': true, 'Virtual Economy Specialist': true, 'Transaction Auditor': true
        }
    };

    $('#role').change(function() {
        var role = $(this).val();
        
        if (role && rolePermissions[role]) {
            var permissions = rolePermissions[role];
            var html = '<div class="row">';
            
            for (var perm in permissions) {
                var hasAccess = permissions[perm];
                var icon = hasAccess ? 'check-circle-fill text-success' : 'x-circle-fill text-danger';
                html += '<div class="col-md-4 mb-2">';
                html += '<i class="bi bi-' + icon + '"></i> ' + perm;
                html += '</div>';
            }
            
            html += '</div>';
            $('#permissionsList').html(html);
            $('#permissionsPreview').slideDown();
        } else {
            $('#permissionsPreview').slideUp();
        }
    });
});
</script>

