<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Admin User Details</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>admin/editAdmin/<?php echo $adminId; ?>" class="btn btn-warning">
          <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="<?php echo base_url(); ?>admin/admins" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to List
        </a>
      </div>
    </div>

    <div class="card">
      <div class="card-header <?php 
        $role = isset($adminInfo['role']) ? $adminInfo['role'] : '';
        echo $role === 'admin' ? 'bg-danger' : ($role === 'content' ? 'bg-primary' : 'bg-success');
      ?> text-white">
        <h5 class="mb-0">
          <i class="bi bi-<?php 
            echo $role === 'admin' ? 'shield-fill-check' : ($role === 'content' ? 'file-earmark-text' : 'calculator');
          ?>"></i> 
          <?php echo isset($adminInfo['fullName']) ? htmlspecialchars($adminInfo['fullName']) : 'N/A'; ?>
        </h5>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6 mb-3">
            <strong>Full Name:</strong>
            <p><?php echo isset($adminInfo['fullName']) ? htmlspecialchars($adminInfo['fullName']) : 'N/A'; ?></p>
          </div>

          <div class="col-md-6 mb-3">
            <strong>Email:</strong>
            <p><?php echo isset($adminInfo['email']) ? htmlspecialchars($adminInfo['email']) : 'N/A'; ?></p>
          </div>

          <div class="col-md-6 mb-3">
            <strong>Phone:</strong>
            <p><?php echo isset($adminInfo['phone']) ? htmlspecialchars($adminInfo['phone']) : 'N/A'; ?></p>
          </div>

          <div class="col-md-6 mb-3">
            <strong>Role:</strong>
            <p>
              <?php 
              $roleBadge = 'bg-secondary';
              $roleIcon = 'person';
              $roleName = 'Unknown';
              
              if($role === 'admin') {
                  $roleBadge = 'bg-danger';
                  $roleIcon = 'shield-fill-check';
                  $roleName = 'Administrator';
              } elseif($role === 'content') {
                  $roleBadge = 'bg-primary';
                  $roleIcon = 'file-earmark-text';
                  $roleName = 'Content Manager';
              } elseif($role === 'accountant') {
                  $roleBadge = 'bg-success';
                  $roleIcon = 'calculator';
                  $roleName = 'Accountant';
              }
              
              echo '<span class="badge '.$roleBadge.'"><i class="bi bi-'.$roleIcon.'"></i> '.$roleName.'</span>';
              ?>
            </p>
          </div>

          <div class="col-md-6 mb-3">
            <strong>Status:</strong>
            <p>
              <?php 
              $isActive = isset($adminInfo['isActive']) ? $adminInfo['isActive'] : true;
              if($isActive) {
                  echo '<span class="badge bg-success"><i class="bi bi-check-circle"></i> Active</span>';
              } else {
                  echo '<span class="badge bg-danger"><i class="bi bi-x-circle"></i> Inactive</span>';
              }
              ?>
            </p>
          </div>

          <div class="col-md-6 mb-3">
            <strong>Created Date:</strong>
            <p><?php echo isset($adminInfo['createdDate']) ? date('F j, Y \a\t g:i A', $adminInfo['createdDate'] / 1000) : 'N/A'; ?></p>
          </div>

          <?php if(isset($adminInfo['lastLoginDate']) && $adminInfo['lastLoginDate']) { ?>
          <div class="col-md-6 mb-3">
            <strong>Last Login:</strong>
            <p><?php echo date('F j, Y \a\t g:i A', $adminInfo['lastLoginDate'] / 1000); ?></p>
          </div>
          <?php } ?>
        </div>
      </div>
    </div>

    <!-- Permissions Card -->
  

    <!-- Actions Card -->
    <div class="card mt-3">
      <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-gear"></i> Actions</h6>
      </div>
      <div class="card-body">
        <button class="btn btn-warning" id="changePasswordBtn" data-adminid="<?php echo $adminId; ?>">
          <i class="bi bi-key"></i> Change Password
        </button>
        
        <?php if($isActive) { ?>
        <button class="btn btn-secondary toggleStatusBtn" data-adminid="<?php echo $adminId; ?>" data-active="true">
          <i class="bi bi-dash-circle"></i> Deactivate Account
        </button>
        <?php } else { ?>
        <button class="btn btn-success toggleStatusBtn" data-adminid="<?php echo $adminId; ?>" data-active="false">
          <i class="bi bi-check-circle"></i> Activate Account
        </button>
        <?php } ?>
        
        <button class="btn btn-danger deleteAdmin" data-adminid="<?php echo $adminId; ?>" data-name="<?php echo isset($adminInfo['fullName']) ? htmlspecialchars($adminInfo['fullName']) : ''; ?>">
          <i class="bi bi-trash"></i> Delete Admin
        </button>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script>
$(document).ready(function() {
    $('#changePasswordBtn').click(function() {
        var adminId = $(this).data('adminid');
        
        Swal.fire({
            title: 'Change Password',
            html: '<input id="swal-input-password" type="password" class="swal2-input" placeholder="New Password" minlength="6"><br>' +
                  '<input id="swal-input-confirm" type="password" class="swal2-input" placeholder="Confirm Password" minlength="6">',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-key"></i> Update Password',
            confirmButtonColor: '#ffc107',
            cancelButtonColor: '#6c757d',
            preConfirm: () => {
                const password = document.getElementById('swal-input-password').value;
                const confirm = document.getElementById('swal-input-confirm').value;
                
                if (!password || !confirm) {
                    Swal.showValidationMessage('Please enter both fields');
                    return false;
                }
                
                if (password.length < 6) {
                    Swal.showValidationMessage('Password must be at least 6 characters');
                    return false;
                }
                
                if (password !== confirm) {
                    Swal.showValidationMessage('Passwords do not match');
                    return false;
                }
                
                return password;
            }
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Updating...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/updatePassword',
                    type: 'POST',
                    data: { 
                        adminId: adminId,
                        newPassword: result.value
                    },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Success!',
                                text: response.message,
                                icon: 'success',
                                confirmButtonColor: '#198754'
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: response.message,
                                icon: 'error',
                                confirmButtonColor: '#dc3545'
                            });
                        }
                    }
                });
            }
        });
    });

    $('.toggleStatusBtn').click(function() {
        var adminId = $(this).data('adminid');
        var isActive = $(this).data('active');
        var action = isActive ? 'deactivate' : 'activate';
        
        Swal.fire({
            title: action === 'activate' ? 'Activate Admin?' : 'Deactivate Admin?',
            text: action === 'activate' ? 
                'This will enable login access.' : 
                'This will disable login access.',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: action === 'activate' ? '#198754' : '#ffc107',
            confirmButtonText: action === 'activate' ? '<i class="bi bi-check-circle"></i> Activate' : '<i class="bi bi-dash-circle"></i> Deactivate'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Processing...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/toggleStatus',
                    type: 'POST',
                    data: { adminId: adminId, currentStatus: isActive },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Success!',
                                text: response.message,
                                icon: 'success',
                                confirmButtonColor: '#198754'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    }
                });
            }
        });
    });

    $('.deleteAdmin').click(function() {
        var adminId = $(this).data('adminid');
        var adminName = $(this).data('name');
        
        Swal.fire({
            title: 'Delete Admin?',
            html: '<strong>' + adminName + '</strong><br><br><span style="color: #dc3545;">This action cannot be undone!</span>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            confirmButtonText: '<i class="bi bi-trash"></i> Delete'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Deleting...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/deleteAdmin',
                    type: 'POST',
                    data: { adminId: adminId },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Deleted!',
                                text: response.message,
                                icon: 'success'
                            }).then(() => {
                                window.location.href = '<?php echo base_url(); ?>admin/admins';
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    }
                });
            }
        });
    });
});
</script>

