<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Add New Announcement</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>announcement/announcements" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Announcements
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>announcement/addNewAnnouncement" method="post" id="addAnnouncementForm">
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required 
                     value="<?= isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''; ?>" maxlength="200">
              <?php if(function_exists('form_error') && form_error('title')): ?>
                <span class="text-danger"><?= form_error('title'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
              <textarea class="form-control" id="description" name="description" rows="6" required><?= isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''; ?></textarea>
              <?php if(function_exists('form_error') && form_error('description')): ?>
                <span class="text-danger"><?= form_error('description'); ?></span>
              <?php endif; ?>
              <small class="text-muted">This message will be sent to all users as a push notification if enabled below.</small>
            </div>

            <div class="col-md-12 mb-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" value="1" id="sendNotification" name="sendNotification" checked>
                <label class="form-check-label" for="sendNotification">
                  <i class="bi bi-send"></i> Send push notification to all users
                </label>
              </div>
              <small class="text-muted">If checked, a push notification will be sent to all app users immediately after creating this announcement.</small>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Create Announcement
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-info-circle"></i> Announcement Guidelines</h6>
      </div>
      <div class="card-body">
        <ul>
          <li><strong>Title:</strong> Keep it concise and attention-grabbing (max 200 characters)</li>
          <li><strong>Description:</strong> Provide clear and complete information</li>
          <li><strong>Timing:</strong> Consider the best time to send notifications to maximize engagement</li>
          <li><strong>Frequency:</strong> Avoid sending too many announcements to prevent notification fatigue</li>
          <li><strong>Content:</strong> Make sure the announcement is relevant and valuable to your users</li>
        </ul>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

