<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Edit Announcement</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>announcement/announcements" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Announcements
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>announcement/updateAnnouncement" method="post" id="editAnnouncementForm">
          <input type="hidden" name="announcementId" value="<?php echo $announcementId; ?>">
          
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required 
                     value="<?= isset($announcementInfo['title']) ? htmlspecialchars($announcementInfo['title']) : (isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''); ?>" maxlength="200">
              <?php if(function_exists('form_error') && form_error('title')): ?>
                <span class="text-danger"><?= form_error('title'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
              <textarea class="form-control" id="description" name="description" rows="6" required><?= isset($announcementInfo['description']) ? htmlspecialchars($announcementInfo['description']) : (isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''); ?></textarea>
              <?php if(function_exists('form_error') && form_error('description')): ?>
                <span class="text-danger"><?= form_error('description'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Created Date</label>
              <p class="form-control-plaintext">
                <?php 
                if(isset($announcementInfo['createdDate'])) {
                    echo date('F j, Y \a\t g:i A', $announcementInfo['createdDate'] / 1000);
                } else {
                    echo 'N/A';
                }
                ?>
              </p>
              <small class="text-muted">The creation date cannot be modified</small>
            </div>

            <div class="col-md-12 mb-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" value="1" id="sendNotification" name="sendNotification">
                <label class="form-check-label" for="sendNotification">
                  <i class="bi bi-send"></i> Send updated notification to all users
                </label>
              </div>
              <small class="text-muted">If checked, a push notification with the updated content will be sent to all app users.</small>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update Announcement
              </button>
              <a href="<?php echo base_url(); ?>announcement/announcements" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

