<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Announcement Details</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>announcement/editAnnouncement/<?php echo $announcementId; ?>" class="btn btn-warning">
          <i class="bi bi-pencil"></i> Edit
        </a>
        <button class="btn btn-success resendNotification" data-announcementid="<?php echo $announcementId; ?>">
          <i class="bi bi-send"></i> Send Notification
        </button>
        <a href="<?php echo base_url(); ?>announcement/announcements" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to List
        </a>
      </div>
    </div>

    <div class="card">
      <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
          <i class="bi bi-megaphone"></i> 
          <?php echo isset($announcementInfo['title']) ? htmlspecialchars($announcementInfo['title']) : 'N/A'; ?>
        </h5>
      </div>
      <div class="card-body">
        <div class="row mb-3">
          <div class="col-md-12">
            <label class="fw-bold">Description:</label>
            <p class="mt-2" style="white-space: pre-line;">
              <?php echo isset($announcementInfo['description']) ? htmlspecialchars($announcementInfo['description']) : 'N/A'; ?>
            </p>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6">
            <label class="fw-bold">Created Date:</label>
            <p>
              <?php 
              if(isset($announcementInfo['createdDate'])) {
                  $timestamp = $announcementInfo['createdDate'] / 1000;
                  echo '<i class="bi bi-calendar"></i> ' . date('F j, Y', $timestamp) . '<br>';
                  echo '<i class="bi bi-clock"></i> ' . date('g:i A', $timestamp);
              } else {
                  echo 'N/A';
              }
              ?>
            </p>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Created Timestamp:</label>
            <p>
              <code><?php echo isset($announcementInfo['createdDate']) ? $announcementInfo['createdDate'] : 'N/A'; ?></code>
              <small class="text-muted d-block">(milliseconds)</small>
            </p>
          </div>
        </div>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-gear"></i> Actions</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-12">
            <button class="btn btn-success btn-lg resendNotificationAction" data-announcementid="<?php echo $announcementId; ?>">
              <i class="bi bi-send-fill"></i> Send Push Notification to All Users
            </button>
            <p class="mt-2 text-muted">
              <i class="bi bi-info-circle"></i> This will send a push notification with this announcement to all registered users who have notifications enabled.
            </p>
          </div>
        </div>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header bg-light">
        <h6 class="mb-0"><i class="bi bi-file-text"></i> Preview</h6>
      </div>
      <div class="card-body">
        <p class="text-muted">This is how the notification will appear on user devices:</p>
        <div class="notification-preview p-3 border rounded" style="background: #f8f9fa; max-width: 400px;">
          <div class="d-flex align-items-start">
            <div class="me-3">
              <i class="bi bi-app-indicator" style="font-size: 2rem; color: #0d6efd;"></i>
            </div>
            <div class="flex-grow-1">
              <strong style="font-size: 14px;">
                <?php echo isset($announcementInfo['title']) ? htmlspecialchars($announcementInfo['title']) : 'N/A'; ?>
              </strong>
              <p class="mb-0 text-muted" style="font-size: 13px;">
                <?php 
                if(isset($announcementInfo['description'])) {
                    $desc = htmlspecialchars($announcementInfo['description']);
                    echo strlen($desc) > 100 ? substr($desc, 0, 100) . '...' : $desc;
                } else {
                    echo 'N/A';
                }
                ?>
              </p>
              <small class="text-muted" style="font-size: 11px;">Just now</small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script type="text/javascript">
$(document).ready(function() {
    $('.resendNotification, .resendNotificationAction').click(function(e) {
        e.preventDefault();
        var announcementId = $(this).data('announcementid');
        
        Swal.fire({
            title: 'Send Notification?',
            html: 'This will send push notifications to <strong>all users</strong>.<br><br>Are you sure?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#198754',
            cancelButtonColor: '#6c757d',
            confirmButtonText: '<i class="bi bi-send"></i> Send to All',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Sending...',
                    text: 'Please wait',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?php echo base_url(); ?>announcement/resendNotification',
                    type: 'POST',
                    data: { announcementId: announcementId },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Sent!',
                                text: response.message || 'Notifications sent successfully',
                                icon: 'success',
                                confirmButtonColor: '#198754'
                            });
                        } else if(response.status == 'access') {
                            Swal.fire({
                                title: 'Access Denied',
                                text: 'You do not have permission to perform this action',
                                icon: 'error',
                                confirmButtonColor: '#dc3545'
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: response.message || 'Failed to send notifications',
                                icon: 'error',
                                confirmButtonColor: '#dc3545'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'Error',
                            text: 'Error occurred while sending notifications',
                            icon: 'error',
                            confirmButtonColor: '#dc3545'
                        });
                    }
                });
            }
        });
    });
});
</script>

