<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-badge-ad"></i> Add Advertisement</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Content
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('content/saveAdvertisement'); ?>" method="post" id="addAdForm" enctype="multipart/form-data">
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Advertisement Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required maxlength="200">
              <?php if(function_exists('form_error') && form_error('title')): ?>
                <span class="text-danger"><?= form_error('title'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description</label>
              <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>

            <div class="col-md-6 mb-3">
              <label for="adType" class="form-label">Advertisement Type <span class="text-danger">*</span></label>
              <select class="form-select" id="adType" name="adType" required>
                <option value="">Select Type</option>
                <option value="banner">🖼️ Banner Advertisement</option>
                <option value="popup">💬 Popup Advertisement</option>
                <option value="video">🎬 Video Advertisement</option>
              </select>
              <?php if(function_exists('form_error') && form_error('adType')): ?>
                <span class="text-danger"><?= form_error('adType'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="duration" class="form-label">Duration (seconds) <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="duration" name="duration" required value="5" min="1" max="60">
              <small class="text-muted">How long the ad will be displayed</small>
            </div>

            <div class="col-md-12 mb-3">
              <label for="mediaFile" class="form-label">Media File <span class="text-danger">*</span></label>
              <input type="file" class="form-control" id="mediaFile" name="mediaFile" required>
              <small class="text-muted" id="mediaFileHelp">Select advertisement type first</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="startDate" class="form-label">Start Date <span class="text-danger">*</span></label>
              <input type="date" class="form-control" id="startDate" name="startDate" required value="<?= date('Y-m-d'); ?>">
              <?php if(function_exists('form_error') && form_error('startDate')): ?>
                <span class="text-danger"><?= form_error('startDate'); ?></span>
              <?php endif; ?>
              <small class="text-muted">When the ad campaign starts</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="endDate" class="form-label">End Date <span class="text-danger">*</span></label>
              <input type="date" class="form-control" id="endDate" name="endDate" required>
              <?php if(function_exists('form_error') && form_error('endDate')): ?>
                <span class="text-danger"><?= form_error('endDate'); ?></span>
              <?php endif; ?>
              <small class="text-muted">When the ad campaign ends</small>
            </div>

            <div class="col-md-12 mb-3">
              <label for="clickUrl" class="form-label">Click URL (Destination)</label>
              <input type="url" class="form-control" id="clickUrl" name="clickUrl" placeholder="https://...">
              <small class="text-muted">Optional: Where users go when they click the ad</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="isActive" class="form-label">Status</label>
              <select class="form-select" id="isActive" name="isActive">
                <option value="1" selected>Active</option>
                <option value="0">Inactive</option>
              </select>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-success">
                <i class="bi bi-save"></i> Save Advertisement
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- Info Card -->
    <div class="card mt-3">
      <div class="card-header bg-success text-white">
        <h6 class="mb-0"><i class="bi bi-info-circle"></i> Advertisement Guidelines</h6>
      </div>
      <div class="card-body">
        <ul>
          <li><strong>Banner Ads:</strong> JPG/PNG, recommended size: 1080x200px or 728x90px</li>
          <li><strong>Popup Ads:</strong> JPG/PNG, recommended size: 800x600px or 1080x1920px</li>
          <li><strong>Video Ads:</strong> MP4 format recommended, max 30 seconds, max 100MB</li>
          <li><strong>Duration:</strong> How long the ad displays (5-15 seconds optimal)</li>
          <li><strong>Campaign Dates:</strong> Set start and end dates for the ad campaign</li>
          <li><strong>Click URL:</strong> Optional destination when user taps the ad</li>
          <li><strong>Analytics:</strong> Impressions and clicks tracked automatically</li>
        </ul>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script>
$(document).ready(function() {
    $('#adType').change(function() {
        var adType = $(this).val();
        var helpText = '';
        var acceptTypes = '';
        
        if (adType === 'banner') {
            helpText = 'Upload banner image (JPG, PNG) - Recommended: 1080x200px or 728x90px';
            acceptTypes = 'image/jpeg,image/jpg,image/png';
        } else if (adType === 'popup') {
            helpText = 'Upload popup image (JPG, PNG) - Recommended: 800x600px or 1080x1920px';
            acceptTypes = 'image/jpeg,image/jpg,image/png';
        } else if (adType === 'video') {
            helpText = 'Upload video file (MP4, MOV, AVI) - Max 100MB, recommended max 30 seconds';
            acceptTypes = 'video/mp4,video/mov,video/avi,video/mkv,video/webm';
        }
        
        $('#mediaFileHelp').text(helpText);
        $('#mediaFile').attr('accept', acceptTypes);
    });

    // Set minimum end date to start date
    $('#startDate').change(function() {
        $('#endDate').attr('min', $(this).val());
        
        // If end date is before start date, update it
        if ($('#endDate').val() && $('#endDate').val() < $(this).val()) {
            $('#endDate').val($(this).val());
        }
    });
});
</script>

