<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-camera-video"></i> Add Prioritised Video</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Content
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('content/savePrioritizedVideo'); ?>" method="post" id="addVideoForm" enctype="multipart/form-data">
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Video Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required maxlength="200">
              <?php if(function_exists('form_error') && form_error('title')): ?>
                <span class="text-danger"><?= form_error('title'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description</label>
              <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>

            <div class="col-md-6 mb-3">
              <label for="videoFile" class="form-label">Video File <span class="text-danger">*</span></label>
              <input type="file" class="form-control" id="videoFile" name="videoFile" required accept="video/mp4,video/mov,video/avi,video/mkv,video/webm">
              <small class="text-muted">Supported formats: MP4, MOV, AVI, MKV, WebM (Max: 100MB)</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="thumbnailFile" class="form-label">Thumbnail Image</label>
              <input type="file" class="form-control" id="thumbnailFile" name="thumbnailFile" accept="image/jpeg,image/jpg,image/png,image/gif">
              <small class="text-muted">Optional: JPG, PNG, GIF (Recommended: 1280x720px)</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="priority" class="form-label">Priority <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="priority" name="priority" required value="1" min="1">
              <?php if(function_exists('form_error') && form_error('priority')): ?>
                <span class="text-danger"><?= form_error('priority'); ?></span>
              <?php endif; ?>
              <small class="text-muted">Lower number = higher priority (1 appears first)</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="isActive" class="form-label">Status</label>
              <select class="form-select" id="isActive" name="isActive">
                <option value="1" selected>Active</option>
                <option value="0">Inactive</option>
              </select>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Save Video
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- Info Card -->
    <div class="card mt-3">
      <div class="card-header bg-info text-white">
        <h6 class="mb-0"><i class="bi bi-info-circle"></i> Prioritised Video Guidelines</h6>
      </div>
      <div class="card-body">
        <ul>
          <li><strong>Priority:</strong> Lower numbers appear first (1, 2, 3...)</li>
          <li><strong>Video URL:</strong> Can be YouTube, Vimeo, or direct video link</li>
          <li><strong>Thumbnail:</strong> Recommended size: 1280x720px</li>
          <li><strong>Status:</strong> Inactive videos won't be shown to users</li>
          <li><strong>Analytics:</strong> Views and likes are tracked automatically</li>
        </ul>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

