<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-badge-ad"></i> Edit Advertisement</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Content
        </a>
      </div>
    </div>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('content/updateAdvertisement'); ?>" method="post" enctype="multipart/form-data">
          <input type="hidden" name="adId" value="<?= isset($adId) ? $adId : ''; ?>">
          
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Advertisement Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required 
                     value="<?= isset($adInfo['title']) ? htmlspecialchars($adInfo['title']) : ''; ?>">
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description</label>
              <textarea class="form-control" id="description" name="description" rows="3"><?= isset($adInfo['description']) ? htmlspecialchars($adInfo['description']) : ''; ?></textarea>
            </div>

            <div class="col-md-6 mb-3">
              <label for="adType" class="form-label">Advertisement Type <span class="text-danger">*</span></label>
              <select class="form-select" id="adType" name="adType" required>
                <option value="banner" <?= (isset($adInfo['adType']) && $adInfo['adType'] === 'banner') ? 'selected' : ''; ?>>🖼️ Banner</option>
                <option value="popup" <?= (isset($adInfo['adType']) && $adInfo['adType'] === 'popup') ? 'selected' : ''; ?>>💬 Popup</option>
                <option value="video" <?= (isset($adInfo['adType']) && $adInfo['adType'] === 'video') ? 'selected' : ''; ?>>🎬 Video</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label for="duration" class="form-label">Duration (seconds) <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="duration" name="duration" required 
                     value="<?= isset($adInfo['duration']) ? $adInfo['duration'] : 5; ?>" min="1" max="60">
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Current Media</label>
              <?php if(isset($adInfo['mediaUrl']) && !empty($adInfo['mediaUrl'])): ?>
                <div class="mb-2">
                  <?php if(isset($adInfo['adType']) && $adInfo['adType'] === 'video'): ?>
                    <video src="<?= htmlspecialchars($adInfo['mediaUrl']); ?>" controls style="max-width: 300px; max-height: 200px;"></video>
                  <?php else: ?>
                    <img src="<?= htmlspecialchars($adInfo['mediaUrl']); ?>" style="max-width: 300px; max-height: 200px; object-fit: contain;">
                  <?php endif; ?>
                </div>
              <?php endif; ?>
              <label for="mediaFile" class="form-label">Upload New Media (Optional)</label>
              <input type="file" class="form-control" id="mediaFile" name="mediaFile">
              <small class="text-muted">Leave empty to keep current media</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="startDate" class="form-label">Start Date <span class="text-danger">*</span></label>
              <input type="date" class="form-control" id="startDate" name="startDate" required
                     value="<?= isset($adInfo['startDate']) ? date('Y-m-d', $adInfo['startDate'] / 1000) : date('Y-m-d'); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label for="endDate" class="form-label">End Date <span class="text-danger">*</span></label>
              <input type="date" class="form-control" id="endDate" name="endDate" required
                     value="<?= isset($adInfo['endDate']) ? date('Y-m-d', $adInfo['endDate'] / 1000) : ''; ?>">
            </div>

            <div class="col-md-12 mb-3">
              <label for="clickUrl" class="form-label">Click URL</label>
              <input type="url" class="form-control" id="clickUrl" name="clickUrl" 
                     value="<?= isset($adInfo['clickUrl']) ? htmlspecialchars($adInfo['clickUrl']) : ''; ?>">
            </div>

            <div class="col-md-4 mb-3">
              <label for="isActive" class="form-label">Status</label>
              <select class="form-select" id="isActive" name="isActive">
                <option value="true" <?= (isset($adInfo['isActive']) && $adInfo['isActive'] === true) ? 'selected' : ''; ?>>Active</option>
                <option value="false" <?= (isset($adInfo['isActive']) && $adInfo['isActive'] === false) ? 'selected' : ''; ?>>Inactive</option>
              </select>
            </div>

            <div class="col-md-8 mb-3">
              <label class="form-label">Statistics</label>
              <p class="form-control-plaintext">
                📊 <?= isset($adInfo['impressions']) ? number_format($adInfo['impressions']) : 0; ?> impressions | 
                👆 <?= isset($adInfo['clicks']) ? number_format($adInfo['clicks']) : 0; ?> clicks
                <?php 
                $imp = isset($adInfo['impressions']) ? $adInfo['impressions'] : 0;
                $clk = isset($adInfo['clicks']) ? $adInfo['clicks'] : 0;
                $ctr = $imp > 0 ? ($clk / $imp) * 100 : 0;
                ?>
                | 📈 <?= number_format($ctr, 2); ?>% CTR
              </p>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-success">
                <i class="bi bi-save"></i> Update Advertisement
              </button>
              <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

