<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-camera-video"></i> Edit Prioritized Video</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Content
        </a>
      </div>
    </div>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('content/updateVideo'); ?>" method="post" enctype="multipart/form-data">
          <input type="hidden" name="videoId" value="<?= isset($videoId) ? $videoId : ''; ?>">
          
          <div class="row">
            <div class="col-md-12 mb-3">
              <label for="title" class="form-label">Video Title <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="title" name="title" required 
                     value="<?= isset($videoInfo['title']) ? htmlspecialchars($videoInfo['title']) : ''; ?>">
            </div>

            <div class="col-md-12 mb-3">
              <label for="description" class="form-label">Description</label>
              <textarea class="form-control" id="description" name="description" rows="3"><?= isset($videoInfo['description']) ? htmlspecialchars($videoInfo['description']) : ''; ?></textarea>
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Current Video</label>
              <?php if(isset($videoInfo['videoUrl']) && !empty($videoInfo['videoUrl'])): ?>
                <div class="mb-2">
                  <video src="<?= htmlspecialchars($videoInfo['videoUrl']); ?>" controls style="max-width: 400px; max-height: 250px;"></video>
                </div>
              <?php endif; ?>
              <label for="videoFile" class="form-label">Upload New Video (Optional)</label>
              <input type="file" class="form-control" id="videoFile" name="videoFile" accept="video/mp4,video/mov,video/avi,video/mkv,video/webm">
              <small class="text-muted">Leave empty to keep current video</small>
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Current Thumbnail</label>
              <?php if(isset($videoInfo['thumbnailUrl']) && !empty($videoInfo['thumbnailUrl'])): ?>
                <div class="mb-2">
                  <img src="<?= htmlspecialchars($videoInfo['thumbnailUrl']); ?>" style="max-width: 300px; max-height: 200px; object-fit: contain;">
                </div>
              <?php endif; ?>
              <label for="thumbnailFile" class="form-label">Upload New Thumbnail (Optional)</label>
              <input type="file" class="form-control" id="thumbnailFile" name="thumbnailFile" accept="image/jpeg,image/jpg,image/png,image/gif">
              <small class="text-muted">Leave empty to keep current thumbnail</small>
            </div>

            <div class="col-md-4 mb-3">
              <label for="priority" class="form-label">Priority <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="priority" name="priority" required 
                     value="<?= isset($videoInfo['priority']) ? $videoInfo['priority'] : 1; ?>" min="1">
            </div>

            <div class="col-md-4 mb-3">
              <label for="isActive" class="form-label">Status</label>
              <select class="form-select" id="isActive" name="isActive">
                <option value="true" <?= (isset($videoInfo['isActive']) && $videoInfo['isActive'] === true) ? 'selected' : ''; ?>>Active</option>
                <option value="false" <?= (isset($videoInfo['isActive']) && $videoInfo['isActive'] === false) ? 'selected' : ''; ?>>Inactive</option>
              </select>
            </div>

            <div class="col-md-4 mb-3">
              <label class="form-label">Statistics</label>
              <p class="form-control-plaintext">
                👁️ <?= isset($videoInfo['views']) ? number_format($videoInfo['views']) : 0; ?> views | 
                ❤️ <?= isset($videoInfo['likes']) ? number_format($videoInfo['likes']) : 0; ?> likes
              </p>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update Video
              </button>
              <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

