<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-badge-ad"></i> Advertisement Details</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/editAdvertisement/'.$adId); ?>" class="btn btn-warning">
          <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back
        </a>
      </div>
    </div>

    <div class="row">
      <!-- Ad Preview Card -->
      <div class="col-md-8">
        <div class="card">
          <div class="card-header bg-success text-white">
            <h5 class="mb-0"><?= isset($adInfo['title']) ? htmlspecialchars($adInfo['title']) : 'N/A'; ?></h5>
          </div>
          <div class="card-body">
            <?php 
            $adType = isset($adInfo['adType']) ? $adInfo['adType'] : 'banner';
            $mediaUrl = isset($adInfo['mediaUrl']) ? $adInfo['mediaUrl'] : '';
            ?>
            
            <?php if($adType === 'video' && !empty($mediaUrl)): ?>
              <div class="ratio ratio-16x9 mb-3">
                <video src="<?= htmlspecialchars($mediaUrl); ?>" controls></video>
              </div>
            <?php elseif(!empty($mediaUrl)): ?>
              <div class="text-center mb-3">
                <img src="<?= htmlspecialchars($mediaUrl); ?>" class="img-fluid rounded" alt="Advertisement" style="max-height: 600px;">
              </div>
            <?php endif; ?>
            
            <?php if(isset($adInfo['description'])): ?>
              <p><?= nl2br(htmlspecialchars($adInfo['description'])); ?></p>
            <?php endif; ?>

            <?php if(isset($adInfo['clickUrl']) && !empty($adInfo['clickUrl'])): ?>
              <p class="mt-3">
                <strong>Click Destination:</strong><br>
                <a href="<?= htmlspecialchars($adInfo['clickUrl']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                  <?= htmlspecialchars($adInfo['clickUrl']); ?> <i class="bi bi-box-arrow-up-right"></i>
                </a>
              </p>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Details Card -->
      <div class="col-md-4">
        <div class="card">
          <div class="card-header">
            <h6 class="mb-0">Advertisement Info</h6>
          </div>
          <div class="card-body">
            <div class="mb-3">
              <strong>Type:</strong>
              <p>
                <?php
                $typeBadge = 'bg-secondary';
                $typeIcon = 'image';
                if($adType === 'banner') {
                    $typeBadge = 'bg-info';
                    $typeIcon = 'layout-text-window';
                } elseif($adType === 'popup') {
                    $typeBadge = 'bg-warning';
                    $typeIcon = 'window-stack';
                } elseif($adType === 'video') {
                    $typeBadge = 'bg-primary';
                    $typeIcon = 'camera-video';
                }
                ?>
                <span class="badge <?= $typeBadge; ?>">
                  <i class="bi bi-<?= $typeIcon; ?>"></i> <?= ucfirst($adType); ?>
                </span>
              </p>
            </div>

            <div class="mb-3">
              <strong>Campaign Period:</strong>
              <p>
                📅 <strong>Start:</strong> <?= isset($adInfo['startDate']) ? date('M j, Y', $adInfo['startDate'] / 1000) : 'N/A'; ?><br>
                🏁 <strong>End:</strong> <?= isset($adInfo['endDate']) ? date('M j, Y', $adInfo['endDate'] / 1000) : 'N/A'; ?>
              </p>
              <?php
              $now = time() * 1000;
              $isRunning = false;
              if(isset($adInfo['startDate']) && isset($adInfo['endDate'])) {
                  $isRunning = ($now >= $adInfo['startDate'] && $now <= $adInfo['endDate']);
              }
              
              if($isRunning): ?>
                <span class="badge bg-success"><i class="bi bi-play-circle"></i> Currently Running</span>
              <?php elseif($now < $adInfo['startDate']): ?>
                <span class="badge bg-secondary"><i class="bi bi-clock"></i> Scheduled</span>
              <?php else: ?>
                <span class="badge bg-dark"><i class="bi bi-stop-circle"></i> Campaign Ended</span>
              <?php endif; ?>
            </div>

            <div class="mb-3">
              <strong>Duration:</strong>
              <p><?= isset($adInfo['duration']) ? $adInfo['duration'] : 0; ?> seconds</p>
            </div>

            <div class="mb-3">
              <strong>Status:</strong>
              <p>
                <?php
                $isActive = isset($adInfo['isActive']) ? $adInfo['isActive'] : true;
                if($isActive): ?>
                  <span class="badge bg-success"><i class="bi bi-check-circle"></i> Active</span>
                <?php else: ?>
                  <span class="badge bg-secondary"><i class="bi bi-dash-circle"></i> Inactive</span>
                <?php endif; ?>
              </p>
            </div>

            <div class="mb-3">
              <strong>Impressions:</strong>
              <p><i class="bi bi-bar-chart-fill"></i> <?= isset($adInfo['impressions']) ? number_format($adInfo['impressions']) : 0; ?></p>
            </div>

            <div class="mb-3">
              <strong>Clicks:</strong>
              <p><i class="bi bi-hand-index-fill"></i> <?= isset($adInfo['clicks']) ? number_format($adInfo['clicks']) : 0; ?></p>
            </div>

            <div class="mb-3">
              <strong>Click Rate (CTR):</strong>
              <p>
                <?php 
                $impressions = isset($adInfo['impressions']) ? $adInfo['impressions'] : 0;
                $clicks = isset($adInfo['clicks']) ? $adInfo['clicks'] : 0;
                $ctr = $impressions > 0 ? ($clicks / $impressions) * 100 : 0;
                ?>
                <span class="badge bg-info"><?= number_format($ctr, 2); ?>%</span>
              </p>
            </div>

            <div class="mb-3">
              <strong>Created:</strong>
              <p><?= isset($adInfo['createdDate']) ? date('F j, Y \a\t g:i A', $adInfo['createdDate'] / 1000) : 'N/A'; ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

