<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-camera-video"></i> Video Details</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('content/editVideo/'.$videoId); ?>" class="btn btn-warning">
          <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="<?= base_url('content/content'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back
        </a>
      </div>
    </div>

    <div class="row">
      <!-- Video Player Card -->
      <div class="col-md-8">
        <div class="card">
          <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><?= isset($videoInfo['title']) ? htmlspecialchars($videoInfo['title']) : 'N/A'; ?></h5>
          </div>
          <div class="card-body">
            <?php if(isset($videoInfo['videoUrl'])): ?>
              <div class="ratio ratio-16x9 mb-3">
                <iframe src="<?= htmlspecialchars($videoInfo['videoUrl']); ?>" allowfullscreen></iframe>
              </div>
            <?php endif; ?>
            
            <?php if(isset($videoInfo['description'])): ?>
              <p><?= nl2br(htmlspecialchars($videoInfo['description'])); ?></p>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Details Card -->
      <div class="col-md-4">
        <div class="card">
          <div class="card-header">
            <h6 class="mb-0">Video Information</h6>
          </div>
          <div class="card-body">
            <div class="mb-3">
              <strong>Priority:</strong>
              <p><span class="badge bg-info fs-5"><?= isset($videoInfo['priority']) ? $videoInfo['priority'] : 'N/A'; ?></span></p>
            </div>

            <div class="mb-3">
              <strong>Status:</strong>
              <p>
                <?php
                $isActive = isset($videoInfo['isActive']) ? $videoInfo['isActive'] : true;
                if($isActive): ?>
                  <span class="badge bg-success"><i class="bi bi-check-circle"></i> Active</span>
                <?php else: ?>
                  <span class="badge bg-secondary"><i class="bi bi-dash-circle"></i> Inactive</span>
                <?php endif; ?>
              </p>
            </div>

            <div class="mb-3">
              <strong>Views:</strong>
              <p><i class="bi bi-eye-fill"></i> <?= isset($videoInfo['views']) ? number_format($videoInfo['views']) : 0; ?></p>
            </div>

            <div class="mb-3">
              <strong>Likes:</strong>
              <p><i class="bi bi-heart-fill text-danger"></i> <?= isset($videoInfo['likes']) ? number_format($videoInfo['likes']) : 0; ?></p>
            </div>

            <div class="mb-3">
              <strong>Created:</strong>
              <p><?= isset($videoInfo['createdDate']) ? date('F j, Y', $videoInfo['createdDate'] / 1000) : 'N/A'; ?></p>
            </div>

            <?php if(isset($videoInfo['thumbnailUrl']) && !empty($videoInfo['thumbnailUrl'])): ?>
            <div class="mb-3">
              <strong>Thumbnail:</strong>
              <img src="<?= htmlspecialchars($videoInfo['thumbnailUrl']); ?>" class="img-fluid rounded mt-2" alt="Thumbnail">
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

