<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Add New user</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>customer/customers" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Users
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>customer/addNewCustomer" method="post" id="addCustomerForm">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="fullName" class="form-label">Full Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="fullName" name="fullName" required>
              <span class="text-danger"><?php echo form_error('fullName'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="userName" class="form-label">Username <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="userName" name="userName" required 
                     placeholder="Enter username (lowercase)">
              <span class="text-danger"><?php echo form_error('userName'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
              <input type="email" class="form-control" id="email" name="email" required>
              <span class="text-danger"><?php echo form_error('email'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="phoneNumber" class="form-label">Phone Number</label>
              <input type="tel" class="form-control" id="phoneNumber" name="phoneNumber" placeholder="e.g. +1 555 123 4567">
              <span class="text-danger"><?php echo form_error('phoneNumber'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="dob" class="form-label">Date of Birth</label>
              <input type="date" class="form-control" id="dob" name="dob">
              <span class="text-danger"><?php echo form_error('dob'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
              <input type="password" class="form-control" id="password" name="password" required>
              <span class="text-danger"><?php echo form_error('password'); ?></span>
              <small class="text-muted">Minimum 6 characters</small>
            </div>
            <div class="col-md-6 mb-3">
              <label for="password" class="form-label">Blue Tick <span class="text-danger">*</span></label>
              <select class="form-select" id="blueTick" name="blueTick">
                <option value="yes">Yes</option>
                <option value="no">No</option>
              </select>
              <span class="text-danger"><?php echo form_error('blueTick'); ?></span>
            </div>

        

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Save User
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

