<?php
    $customers = isset($customers) && is_array($customers) ? $customers : [];
    $approvedCount = count($customers);
    $createdToday = 0;
    $suspended = 0;
    $warned = 0;

    if ($approvedCount > 0) {
        $today = (new DateTime('today'))->setTime(0,0,0)->getTimestamp();
        foreach ($customers as $customer) {
            $status = strtolower($customer['status'] ?? '');
            if ($status === 'suspended' || $status === 'suspend') {
                $suspended++;
            } elseif ($status === 'warning') {
                $warned++;
            }
            $createdAt = isset($customer['createdAt']) ? (int)$customer['createdAt'] : 0;
            if ($createdAt >= ($today * 1000)) {
                $createdToday++;
            }
        }
    }
?>

<style>
    .approved-hero {
        background: linear-gradient(120deg, #16a34a, #22c55e);
        border-radius: 24px;
        padding: 32px;
        color: #fff;
        margin-bottom: 28px;
        box-shadow: 0 25px 50px -12px rgba(34, 197, 94, 0.35);
        position: relative;
        overflow: hidden;
    }
    .approved-hero::after {
        content: "";
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at top right, rgba(255,255,255,0.35), transparent 60%);
        opacity: 0.6;
    }
    .approved-hero h1 {
        font-size: 1.9rem;
        font-weight: 700;
    }
    .approved-hero p {
        margin: 6px 0 16px;
        opacity: 0.9;
    }
    .approved-hero .hero-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 14px;
        border-radius: 999px;
        background: rgba(255,255,255,0.2);
        font-weight: 600;
    }
    .approved-metrics .card {
        border: none;
        border-radius: 18px;
        box-shadow: 0 12px 30px rgba(15, 23, 42, 0.08);
        transition: transform 0.25s ease;
    }
    .approved-metrics .card:hover {
        transform: translateY(-4px);
    }
    .approved-metrics .metric-label {
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #94a3b8;
    }
    .approved-metrics .metric-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #065f46;
    }
    .filter-card {
        border: none;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 12px 24px rgba(15, 23, 42, 0.06);
        margin-bottom: 28px;
    }
    .filter-card .form-control {
        border-radius: 14px;
        padding: 12px 14px;
        border-color: #e2e8f0;
    }
    .table-card {
        border: none;
        border-radius: 20px;
        box-shadow: 0 16px 32px rgba(15, 23, 42, 0.08);
    }
</style>

<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <section class="approved-hero">
        <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between position-relative">
            <div>
                <h1>Approved Customers</h1>
                <p>Every member on this list has passed onboarding, verification, and compliance checks.</p>
                <div class="hero-badge">
                    <i class="bi bi-check-circle-fill"></i>
                    <?php echo number_format($approvedCount); ?> approved customers
                </div>
            </div>
            <div class="mt-4 mt-lg-0 text-lg-end">
                <a href="<?php echo base_url(); ?>customer/addCustomer" class="btn btn-light text-success fw-semibold px-4 py-2">
                    <i class="bi bi-plus-circle me-2"></i>Add Customer
                </a>
            </div>
        </div>
    </section>

    <section class="approved-metrics mb-4">
        <div class="row g-3">
            <div class="col-md-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="metric-label">New today</div>
                        <div class="metric-value text-success"><?php echo number_format($createdToday); ?></div>
                        <div class="text-muted">Approved in the last 24h</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="metric-label">Warned</div>
                        <div class="metric-value text-warning"><?php echo number_format($warned); ?></div>
                        <div class="text-muted">Need monitoring</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="metric-label">Suspended</div>
                        <div class="metric-value text-danger"><?php echo number_format($suspended); ?></div>
                        <div class="text-muted">Under review</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="metric-label">Compliance rate</div>
                        <div class="metric-value text-primary">
                            <?php echo $approvedCount > 0 ? number_format((($approvedCount - ($warned + $suspended)) / $approvedCount) * 100, 0) . '%' : '0%'; ?>
                        </div>
                        <div class="text-muted">Clean accounts</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="filter-card bg-white">
        <form action="<?php echo base_url(); ?>customer/approved" method="post" class="row g-3 align-items-end">
            <div class="col-md-8">
                <label for="searchText" class="form-label fw-semibold text-muted">Search approved customers</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0">
                        <i class="bi bi-search text-success"></i>
                    </span>
                    <input type="text"
                           id="searchText"
                           class="form-control border-start-0"
                           name="searchText"
                           placeholder="Name, email, or phone..."
                           value="<?php echo !empty($searchText) ? $searchText : ''; ?>">
                </div>
            </div>
            <div class="col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary px-4 w-100">Search</button>
                <?php if(!empty($searchText)) { ?>
                    <a href="<?php echo base_url(); ?>customer/approved" class="btn btn-outline-secondary w-100">Clear</a>
                <?php } ?>
            </div>
        </form>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs custom-tabs" id="customerTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?php echo base_url(); ?>customer/customers">All Customers</a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link active" href="<?php echo base_url(); ?>customer/approved">Approved</a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?php echo base_url(); ?>customer/unapproved">Unapproved</a>
      </li>
    </ul>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card table-card">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead>
              <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Status</th>
                <th>Created</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              if(!empty($customers)) {
                  $count = 1;
                  foreach($customers as $customerId => $customer) {
                      $firstName = isset($customer['firstName']) ? $customer['firstName'] : 'N/A';
                      $email = isset($customer['email']) ? $customer['email'] : 'N/A';
                      $phone = isset($customer['phone']) ? $customer['phone'] : 'N/A';
                      $status = isset($customer['status']) ? $customer['status'] : 'N/A';
                      $createdAt = isset($customer['createdAt']) ? date('Y-m-d', $customer['createdAt'] / 1000) : 'N/A';
                      
                      $statusClass = 'status-proceed';
                      if($status == 'suspended') {
                          $statusClass = 'status-reject';
                         } elseif($status == 'warning') {
                          $statusClass = 'status-warn';
                      }
              ?>
              <tr>
                <td><?php echo $count++; ?></td>
                <td><?php echo htmlspecialchars($firstName); ?></td>
                <td><?php echo htmlspecialchars($email); ?></td>
                <td><?php echo htmlspecialchars($phone); ?></td>
                <td>
                  <span class="status-pill <?php echo $statusClass; ?>">
                    <span class="status-dot me-1"></span><?php echo ucfirst($status); ?>
                  </span>
                </td>
                <td><?php echo $createdAt; ?></td>
                <td>
                  <a href="<?php echo base_url().'customer/viewCustomer/'.$customerId; ?>" class="btn btn-sm btn-info">
                    <i class="bi bi-eye"></i> View
                  </a>
                  <a href="<?php echo base_url().'customer/editCustomer/'.$customerId; ?>" class="btn btn-sm btn-warning">
                    <i class="bi bi-pencil"></i> Edit
                  </a>
                </td>
              </tr>
              <?php
                  }
              } else {
              ?>
              <tr>
                <td colspan="7" class="text-center">No approved customers found</td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

