<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Edit Customer</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>customer/customers" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Customers
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>customer/updateCustomer" method="post" id="editCustomerForm">
          <input type="hidden" name="customerId" value="<?php echo $customerId; ?>">
          <input type="hidden" name="email" value="<?php echo isset($customerInfo['email']) ? $customerInfo['email'] : ''; ?>">
          
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="fullName" class="form-label">Full Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="fullName" name="fullName" required 
                     value="<?php echo isset($customerInfo['fullName']) ? $customerInfo['fullName'] : set_value('fullName'); ?>">
              <span class="text-danger"><?php echo form_error('fullName'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="userName" class="form-label">Username <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="userName" name="userName" required 
                     value="<?php echo isset($customerInfo['userName']) ? $customerInfo['userName'] : set_value('userName'); ?>">
              <span class="text-danger"><?php echo form_error('userName'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="email" class="form-label">Email Address</label>
              <input type="email" class="form-control" id="email" value="<?php echo isset($customerInfo['email']) ? $customerInfo['email'] : ''; ?>" disabled>
              <small class="text-muted">Email cannot be changed</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="userCoins" class="form-label">User Coins</label>
              <input type="number" class="form-control" id="userCoins" name="userCoins" 
                     value="<?php echo isset($customerInfo['userCoins']) ? $customerInfo['userCoins'] : 0; ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label for="IsActive" class="form-label">Account Status <span class="text-danger">*</span></label>
              <select class="form-select" id="IsActive" name="IsActive" required>
                <option value="true" <?php echo (isset($customerInfo['IsActive']) && $customerInfo['IsActive'] === true) ? 'selected' : ''; ?>>Active</option>
                <option value="false" <?php echo (isset($customerInfo['IsActive']) && $customerInfo['IsActive'] === false) ? 'selected' : ''; ?>>Suspended</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label for="NooFwarning" class="form-label">Number of Warnings</label>
              <input type="number" class="form-control" id="NooFwarning" name="NooFwarning" disabled
                     value="<?php echo isset($customerInfo['NooFwarning']) ? $customerInfo['NooFwarning'] : 0; ?>">
              <small class="text-muted">Use "Add Warning" button on listing page to modify</small>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update Customer
              </button>
              <a href="<?php echo base_url(); ?>customer/customers" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

