<?php
if (!function_exists('foryou_format_datetime')) {
    function foryou_format_datetime($timestamp)
    {
        if (empty($timestamp)) {
            return 'Unknown';
        }
        if ($timestamp > 1000000000000) {
            $timestamp = (int)round($timestamp / 1000);
        }
        return date('M j, Y g:i A', $timestamp);
    }
}

if (!function_exists('foryou_relative_time')) {
    function foryou_relative_time($timestamp)
    {
        if (empty($timestamp)) {
            return '—';
        }
        if ($timestamp > 1000000000000) {
            $timestamp = (int)round($timestamp / 1000);
        }
        $now = time();
        $diff = max(0, $now - $timestamp);
        if ($diff < 60) {
            return $diff . 's ago';
        }
        if ($diff < 3600) {
            return floor($diff / 60) . 'm ago';
        }
        if ($diff < 86400) {
            return floor($diff / 3600) . 'h ago';
        }
        if ($diff < 604800) {
            return floor($diff / 86400) . 'd ago';
        }
        return date('M j, Y', $timestamp);
    }
}
?>

<?php
$posts = $posts ?? [];
$context = $context ?? 'feed';
$isFeedContext = ($context === 'feed');
?>

<?php if (!empty($posts)): ?>
  <?php foreach ($posts as $post): ?>
    <div class="col-xl-4 col-lg-6 foryou-post-card" data-post-id="<?php echo htmlspecialchars($post['id']); ?>">
      <div class="card post-card shadow-sm border-0 h-100">
        <?php if (!empty($post['videoUrl'])): ?>
          <div class="post-media">
            <video class="post-video" controls preload="metadata" poster="<?php echo !empty($post['imageUrl']) ? htmlspecialchars($post['imageUrl']) : ''; ?>">
              <source src="<?php echo htmlspecialchars($post['videoUrl']); ?>" type="video/mp4">
              Your browser does not support the video tag.
            </video>
            <?php if (!empty($post['isPin'])): ?>
              <span class="badge badge-overlay bg-danger"><i class="bi bi-pin-angle"></i> Pinned</span>
            <?php endif; ?>
          </div>
        <?php elseif (!empty($post['imageUrl'])): ?>
          <div class="post-media">
            <img src="<?php echo htmlspecialchars($post['imageUrl']); ?>" class="img-fluid" alt="Post image">
          </div>
        <?php endif; ?>

        <div class="card-body d-flex flex-column">
          <div class="d-flex align-items-center mb-3">
            <div class="me-3">
              <?php if (!empty($post['author']['avatar'])): ?>
                <img src="<?php echo htmlspecialchars($post['author']['avatar']); ?>" class="author-avatar" alt="Author avatar">
              <?php else: ?>
                <div class="author-avatar placeholder"><i class="bi bi-person-fill"></i></div>
              <?php endif; ?>
            </div>
            <div>
              <h6 class="mb-0"><?php echo htmlspecialchars($post['author']['name']); ?></h6>
              <small class="text-muted">@<?php echo htmlspecialchars($post['author']['userName']); ?> • <?php echo foryou_relative_time($post['createdDate'] ?? 0); ?></small>
            </div>
          </div>

          <?php if (!empty($post['songDetails'])): ?>
            <div class="song-chip mb-2"><i class="bi bi-music-note-beamed me-2"></i><?php echo htmlspecialchars($post['songDetails']); ?></div>
          <?php endif; ?>

          <?php if (!empty($post['details'])): ?>
            <p class="post-description"><?php echo nl2br(htmlspecialchars($post['details'])); ?></p>
          <?php endif; ?>

          <?php if (!empty($post['hashtags'])): ?>
            <div class="hashtags mb-3">
              <?php foreach ($post['hashtags'] as $tag): ?>
                <span class="badge rounded-pill bg-light text-primary">#<?php echo htmlspecialchars($tag); ?></span>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>

          <div class="mt-auto">
            <div class="d-flex flex-wrap gap-3 mb-3 text-muted">
              <?php if (!empty($post['city'])): ?>
                <span class="d-inline-flex align-items-center"><i class="bi bi-geo-alt me-2"></i><?php echo htmlspecialchars($post['city']); ?></span>
              <?php endif; ?>
              <?php if (!empty($post['address'])): ?>
                <span class="d-inline-flex align-items-center"><i class="bi bi-map me-2"></i><?php echo htmlspecialchars($post['address']); ?></span>
              <?php endif; ?>
              <span class="d-inline-flex align-items-center"><i class="bi bi-eye me-2"></i><?php echo (count($post['totalviews']) > 0) ? number_format(count($post['totalviews']) ?? 0) : 0; ?> views</span>
              <?php
                $likedUser = isset($post['likedUser']) && is_array($post['likedUser']) ? $post['likedUser'] : [];
                $likesCount = count($likedUser);
              ?>
              <span class="d-inline-flex align-items-center"><i class="bi bi-heart me-2"></i><?php echo number_format($likesCount); ?> likes</span>
              <?php
                $saveVideos = isset($post['saveVideos']) && is_array($post['saveVideos']) ? $post['saveVideos'] : [];
                $savedCount = count($saveVideos);
              ?>
              <span class="d-inline-flex align-items-center"><i class="bi bi-bookmark me-2"></i><?php echo number_format($savedCount); ?> saved</span>
              <span class="d-inline-flex align-items-center"><i class="bi bi-lock me-2"></i><?php echo htmlspecialchars($post['privacy']); ?></span>
            </div>

         

            <div class="collapse mt-3" id="meta-<?php echo htmlspecialchars($post['id']); ?>">
              <div class="meta-grid">
                <div>
                  <span class="meta-label">Post ID</span>
                  <span class="meta-value text-truncate" title="<?php echo htmlspecialchars($post['id']); ?>"><?php echo htmlspecialchars($post['id']); ?></span>
                </div>
                <div>
                  <span class="meta-label">Created</span>
                  <span class="meta-value"><?php echo foryou_format_datetime($post['createdDate'] ?? 0); ?></span>
                </div>
                <div>
                  <span class="meta-label">Latitude</span>
                  <span class="meta-value"><?php echo isset($post['lat']) ? number_format($post['lat'], 6) : '—'; ?></span>
                </div>
                <div>
                  <span class="meta-label">Longitude</span>
                  <span class="meta-value"><?php echo isset($post['lng']) ? number_format($post['lng'], 6) : '—'; ?></span>
                </div>
              </div>
            </div>

            <?php if ($isFeedContext): ?>
              <button type="button" class="btn btn-outline-primary btn-sm w-100 mt-3 btn-appropriate-post" data-post-id="<?php echo htmlspecialchars($post['id']); ?>">
                <i class="bi bi-check-circle me-1"></i>Remove from For You page
              </button>
            <?php else: ?>
              <button type="button" class="btn btn-outline-danger btn-sm w-100 mt-3 btn-delete-post" data-post-id="<?php echo htmlspecialchars($post['id']); ?>">
                <i class="bi bi-trash me-1"></i>Delete Post
              </button>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
<?php endif; ?>

