<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-plus-circle"></i> Add New Gift</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('gifts'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Gifts
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('gifts/addNewGift'); ?>" method="post" enctype="multipart/form-data" id="addGiftForm">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="name" class="form-label">Gift Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="name" name="name" required 
                     value="<?= isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>" maxlength="100"
                     placeholder="e.g., Dice, Rose, Diamond">
              <?php if(function_exists('form_error') && form_error('name')): ?>
                <span class="text-danger"><?= form_error('name'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="giftType" class="form-label">Gift Type <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="giftType" name="giftType" required 
                     value="<?= isset($_POST['giftType']) ? htmlspecialchars($_POST['giftType']) : ''; ?>" maxlength="100"
                     placeholder="e.g., Dice, Flower, Jewelry">
              <?php if(function_exists('form_error') && form_error('giftType')): ?>
                <span class="text-danger"><?= form_error('giftType'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="value" class="form-label">Coin Value <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="value" name="value" required 
                     value="<?= isset($_POST['value']) ? htmlspecialchars($_POST['value']) : ''; ?>" 
                     min="1" step="1" placeholder="e.g., 200">
              <?php if(function_exists('form_error') && form_error('value')): ?>
                <span class="text-danger"><?= form_error('value'); ?></span>
              <?php endif; ?>
              <small class="text-muted">Number of coins required to send this gift</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="image" class="form-label">Gift Image <span class="text-danger">*</span></label>
              <input type="file" class="form-control" id="image" name="image" accept="image/*" required>
              <small class="text-muted">Supported formats: JPG, JPEG, PNG, GIF, WEBP (Max: 5MB)</small>
            </div>

            <div class="col-md-12 mb-3">
              <div id="imagePreview" style="display: none;">
                <label class="form-label">Image Preview</label>
                <div>
                  <img id="previewImg" src="" alt="Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #ddd;">
                </div>
              </div>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Add Gift
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-info-circle"></i> Gift Guidelines</h6>
      </div>
      <div class="card-body">
        <ul>
          <li><strong>Name:</strong> Use a clear, descriptive name for the gift (e.g., "Rose", "Diamond Ring")</li>
          <li><strong>Type:</strong> Categorize the gift type (e.g., "Flower", "Jewelry", "Trophy")</li>
          <li><strong>Value:</strong> Set the coin value users need to spend to send this gift</li>
          <li><strong>Image:</strong> Upload a high-quality, transparent PNG image for best results</li>
          <li><strong>Consistency:</strong> Maintain consistent image sizes and styles across all gifts</li>
        </ul>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script src="<?= base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    // Image preview
    $('#image').change(function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#previewImg').attr('src', e.target.result);
                $('#imagePreview').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    // Reset preview on form reset
    $('#addGiftForm').on('reset', function() {
        $('#imagePreview').hide();
        $('#previewImg').attr('src', '');
    });
});
</script>

