<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-pencil-square"></i> Edit Gift</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('gifts'); ?>" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Gifts
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <form action="<?= base_url('gifts/updateGift'); ?>" method="post" enctype="multipart/form-data" id="editGiftForm">
          <input type="hidden" name="giftId" value="<?= $giftId; ?>">
          
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="name" class="form-label">Gift Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="name" name="name" required 
                     value="<?= isset($giftInfo['name']) ? htmlspecialchars($giftInfo['name']) : (isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''); ?>" 
                     maxlength="100" placeholder="e.g., Dice, Rose, Diamond">
              <?php if(function_exists('form_error') && form_error('name')): ?>
                <span class="text-danger"><?= form_error('name'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="giftType" class="form-label">Gift Type <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="giftType" name="giftType" required 
                     value="<?= isset($giftInfo['giftType']) ? htmlspecialchars($giftInfo['giftType']) : (isset($_POST['giftType']) ? htmlspecialchars($_POST['giftType']) : ''); ?>" 
                     maxlength="100" placeholder="e.g., Dice, Flower, Jewelry">
              <?php if(function_exists('form_error') && form_error('giftType')): ?>
                <span class="text-danger"><?= form_error('giftType'); ?></span>
              <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
              <label for="value" class="form-label">Coin Value <span class="text-danger">*</span></label>
              <input type="number" class="form-control" id="value" name="value" required 
                     value="<?= isset($giftInfo['value']) ? htmlspecialchars($giftInfo['value']) : (isset($_POST['value']) ? htmlspecialchars($_POST['value']) : ''); ?>" 
                     min="1" step="1" placeholder="e.g., 200">
              <?php if(function_exists('form_error') && form_error('value')): ?>
                <span class="text-danger"><?= form_error('value'); ?></span>
              <?php endif; ?>
              <small class="text-muted">Number of coins required to send this gift</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="image" class="form-label">Gift Image</label>
              <input type="file" class="form-control" id="image" name="image" accept="image/*">
              <small class="text-muted">Leave empty to keep current image. Supported: JPG, PNG, GIF, WEBP (Max: 5MB)</small>
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Current Image</label>
              <div>
                <?php if(isset($giftInfo['image']) && !empty($giftInfo['image'])): ?>
                  <img id="currentImage" src="<?= $giftInfo['image']; ?>" alt="Current Gift Image" 
                       style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #ddd;">
                <?php else: ?>
                  <p class="text-muted">No image uploaded</p>
                <?php endif; ?>
              </div>
            </div>

            <div class="col-md-12 mb-3">
              <div id="imagePreview" style="display: none;">
                <label class="form-label">New Image Preview</label>
                <div>
                  <img id="previewImg" src="" alt="Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #ddd;">
                </div>
              </div>
            </div>

            <div class="col-md-12 mb-3">
              <label class="form-label">Created Date</label>
              <p class="form-control-plaintext">
                <?php 
                if(isset($giftInfo['timestamp'])) {
                    echo date('F j, Y \a\t g:i A', $giftInfo['timestamp'] / 1000);
                } else {
                    echo 'N/A';
                }
                ?>
              </p>
              <small class="text-muted">The creation date cannot be modified</small>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update Gift
              </button>
              <a href="<?= base_url('gifts'); ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script src="<?= base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    // Image preview
    $('#image').change(function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#previewImg').attr('src', e.target.result);
                $('#imagePreview').show();
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            $('#imagePreview').hide();
            $('#previewImg').attr('src', '');
        }
    });
});
</script>

