<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-gift"></i> Gifts Management</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('gifts/addGift'); ?>" class="btn btn-primary">
          <i class="bi bi-plus-circle"></i> Add New Gift
        </a>
      </div>
    </div>

    <div class="row my-2">
      <div class="col-md-12">
        <form action="<?= base_url('gifts'); ?>" method="post">
          <div class="input-group custom-search">
            <span class="input-group-text"><i class="bi bi-search"></i></span>
            <input type="text" class="form-control" name="searchText" placeholder="Search by gift name or type..." 
                   value="<?= !empty($searchText) ? htmlspecialchars($searchText) : ''; ?>" aria-label="Search">
            <button type="submit" class="btn btn-primary">Search</button>
            <?php if(!empty($searchText)): ?>
            <a href="<?= base_url('gifts'); ?>" class="btn btn-secondary">Clear</a>
            <?php endif; ?>
          </div>
        </form>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-striped table-bordered align-middle">
            <thead class="table-light">
              <tr>
                <th>Image</th>
                <th>Gift Name</th>
                <th>Gift Type</th>
                <th>Coin Value</th>
                <th>Created Date</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              if(!empty($gifts)) {
                  foreach($gifts as $giftId => $gift) {
                      $name = isset($gift['name']) ? htmlspecialchars($gift['name']) : 'N/A';
                      $giftType = isset($gift['giftType']) ? htmlspecialchars($gift['giftType']) : 'N/A';
                      $value = isset($gift['value']) ? number_format($gift['value']) : '0';
                      $image = isset($gift['image']) ? $gift['image'] : '';
                      
                      // Format timestamp
                      $createdDate = 'N/A';
                      if (isset($gift['timestamp']) && is_numeric($gift['timestamp'])) {
                          $timestamp = $gift['timestamp'] / 1000;
                          $createdDate = date('M d, Y', $timestamp);
                      }
              ?>
              <tr>
                <td class="text-center">
                  <?php if(!empty($image)): ?>
                    <img src="<?= $image; ?>" alt="<?= $name; ?>" style="width: 60px; height: 60px; object-fit: cover; border-radius: 8px;">
                  <?php else: ?>
                    <div style="width: 60px; height: 60px; background: #f0f0f0; display: flex; align-items: center; justify-content: center; border-radius: 8px;">
                      <i class="bi bi-image" style="font-size: 24px; color: #999;"></i>
                    </div>
                  <?php endif; ?>
                </td>
                <td><strong><?= $name; ?></strong></td>
                <td><?= $giftType; ?></td>
                <td>
                  <span class="badge bg-warning text-dark">
                    <i class="bi bi-coin"></i> <?= $value; ?> Coins
                  </span>
                </td>
                <td><?= $createdDate; ?></td>
                <td>
                  <a href="<?= base_url('gifts/editGift/' . $giftId); ?>" class="btn btn-sm btn-primary" title="Edit">
                    <i class="bi bi-pencil-square"></i>
                  </a>
                  <button class="btn btn-sm btn-danger deleteGift" data-giftid="<?= $giftId; ?>" data-name="<?= $name; ?>" title="Delete">
                    <i class="bi bi-trash"></i>
                  </button>
                </td>
              </tr>
              <?php
                  }
              } else {
                  echo '<tr><td colspan="6" class="text-center">No gifts found. <a href="' . base_url('gifts/addGift') . '">Add your first gift</a></td></tr>';
              }
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

  </div>
</main>
<!--end main wrapper-->

<script src="<?= base_url('assets/js/jquery.min.js'); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    // Delete gift
    $('.deleteGift').click(function(e) {
        e.preventDefault();
        var giftId = $(this).data('giftid');
        var giftName = $(this).data('name');
        
        Swal.fire({
            title: 'Delete Gift?',
            html: 'Are you sure you want to delete <strong>' + giftName + '</strong>?<br><br>This action cannot be undone.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: '<i class="bi bi-trash"></i> Delete',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Deleting...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?= base_url('gifts/deleteGift'); ?>',
                    type: 'POST',
                    data: { giftId: giftId },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Deleted!',
                                text: response.message,
                                icon: 'success',
                                confirmButtonColor: '#0d6efd'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'An error occurred while deleting the gift', 'error');
                    }
                });
            }
        });
    });
});
</script>

