<!doctype html>
<html lang="en" data-bs-theme="light">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Stream Admin | Dashboard</title>
  
  <!--favicon-->
  <link rel="icon" href="<?= base_url('assets/images/favicon-32x32.png'); ?>" type="image/png">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@300;400;500;600&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Material+Icons+Outlined" rel="stylesheet">

  <!-- Plugins CSS -->
  <link href="<?= base_url('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/plugins/metismenu/metisMenu.min.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/plugins/metismenu/mm-vertical.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/plugins/simplebar/css/simplebar.css'); ?>" rel="stylesheet">

  <!-- Bootstrap CSS -->
  <link href="<?= base_url('assets/css/bootstrap.min.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/css/bootstrap-extended.css'); ?>" rel="stylesheet">

  <!-- Theme CSS -->
  <link href="<?= base_url('assets/sass/main.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/sass/dark-theme.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/sass/semi-dark.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/sass/bordered-theme.css'); ?>" rel="stylesheet">
  <link href="<?= base_url('assets/sass/responsive.css'); ?>" rel="stylesheet">

  <!-- External Libraries -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/simple-jscalendar@1.4.5/source/jsCalendar.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.4/dist/sweetalert2.min.css">

  <!-- jQuery -->
  <script src="<?= base_url('assets/js/jquery.min.js'); ?>"></script>

  <!-- Professional Custom Styles -->
  <style>
    /* Professional Color Scheme */
    :root {
      --primary-color: #4f46e5;
      --primary-hover: #4338ca;
      --sidebar-bg: #87d0f0;
      --text-dark: #1f2937;
      --text-muted: #6b7280;
      --border-light: #e5e7eb;
    }

    /* Sidebar Professional Styling */
    .sidebar-wrapper {
      background: var(--sidebar-bg);
      box-shadow: 2px 0 8px rgba(0, 0, 0, 0.06);
      overflow: hidden;
    }

    .sidebar-header {
      background: var(--sidebar-bg);
      border-bottom: 1px solid rgba(255, 255, 255, 0.3);
    }

    .sidebar-nav {
      height: calc(100vh - 140px);
      overflow-y: auto;
      overflow-x: hidden;
      padding-bottom: 20px;
    }

    /* Menu Container */
    .metismenu {
      padding: 10px 0;
      margin: 0;
      list-style: none;
    }

    /* Menu Items */
    .metismenu li {
      list-style: none;
    }

    .metismenu li a {
      color: var(--text-dark) !important;
      padding: 12px 20px;
      border-radius: 8px;
      margin: 4px 12px;
      transition: all 0.3s ease;
      font-weight: 500;
    }

    .metismenu li a:hover {
      background: rgba(79, 70, 229, 0.1);
      color: var(--primary-color) !important;
      transform: translateX(4px);
    }

    .metismenu li a.mm-active {
      background: var(--primary-color);
      color: #ffffff !important;
      box-shadow: 0 2px 8px rgba(79, 70, 229, 0.3);
    }

    /* Icons */
    .icnonDiv {
      width: 36px;
      height: 36px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 12px;
      background: rgba(79, 70, 229, 0.08);
      border-radius: 8px;
      transition: all 0.3s ease;
    }

    .metismenu li a:hover .icnonDiv {
      background: rgba(79, 70, 229, 0.15);
    }

    .metismenu li a.mm-active .icnonDiv {
      background: rgba(255, 255, 255, 0.2);
    }

    .icnonDiv img {
      width: 20px;
      height: 20px;
    }

    .icnonDiv i {
      color: var(--text-dark);
      font-size: 20px;
    }

    .metismenu li a:hover .icnonDiv i {
      color: var(--primary-color);
    }

    .metismenu li a.mm-active .icnonDiv i {
      color: #ffffff;
    }

    /* Menu Title */
    .menu-title {
      font-size: 14px;
      font-weight: 500;
    }

    .metismenu li a.mm-active .menu-title {
      color: #ffffff !important;
    }

    /* Header */
    .top-header {
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
      background: #ffffff;
    }

    /* User Dropdown */
    .dropdown-user {
      border-radius: 12px;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
      border: none;
    }

    .dropdown-user .dropdown-item:hover {
      background: rgba(79, 70, 229, 0.08);
      color: var(--primary-color);
    }

    /* Custom Scrollbar for Sidebar */
    .sidebar-nav::-webkit-scrollbar {
      width: 8px;
    }

    .sidebar-nav::-webkit-scrollbar-track {
      background: rgba(255, 255, 255, 0.3);
      border-radius: 4px;
      margin: 8px 0;
    }

    .sidebar-nav::-webkit-scrollbar-thumb {
      background: rgba(79, 70, 229, 0.4);
      border-radius: 4px;
      transition: background 0.3s ease;
    }

    .sidebar-nav::-webkit-scrollbar-thumb:hover {
      background: rgba(79, 70, 229, 0.7);
    }

    /* Firefox Scrollbar */
    .sidebar-nav {
      scrollbar-width: thin;
      scrollbar-color: rgba(79, 70, 229, 0.4) rgba(255, 255, 255, 0.3);
    }

    /* Responsive */
    @media (max-width: 991px) {
      .metismenu li a {
        margin: 4px 8px;
      }
    }
  </style>
</head>

<body>
  <?php
  $user=$this->session->userdata('session_data');
  ?>

  <!--start header-->
  <header class="top-header">
    <nav class="navbar navbar-expand align-items-center gap-4">
      <div class="p-3  logoDIV LogoR">
     <img src="<?= base_url('assets/images/dplogo.png'); ?>" alt="Logo" width="150px">

      </div>
      <div class="btn-toggle">
        <a href="javascript:;"><i class="material-icons-outlined">menu</i></a>
      </div>
      <h3>Dashboard</h3>
      <div class="search-bar flex-grow-1">
        <div class="position-relative">

          <div class="search-popup p-3">
            <div class="card rounded-4 overflow-hidden">
              <div class="card-body search-content">
              </div>
            </div>
          </div>
        </div>
      </div>
      <ul class="navbar-nav gap-1 nav-right-links align-items-center">
        <li class="nav-item dropdown">
          <a href="javascrpt:;" class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
            <div class="d-flex align-items-center">
              <?php
              if(!empty($user['image'])){
                $image=$user['image'];
              }else{
                $image=base_url('assets/images/avatars/01.png');
              }
              ?>
            <img src="<?= $image; ?>" class="p-1 borderCustom" width="45" height="45" alt="Avatar">

              <div>
                <p class="mb-0 f1"><?= $user['name']; ?></p>
                <p class="mb-0 f2"><?= $user['role']; ?></p>
              </div>
            </div>
          </a>
          <div class="dropdown-menu dropdown-user dropdown-menu-end shadow">
            <a class="dropdown-item gap-2 py-2" href="javascript:;">
              <div class="text-center">
                <?php
                if(!empty($user['image'])){
                  $image=$user['image'];
                }else{
                  $image=base_url('assets/images/avatars/01.png');
                }
                ?>
              <img src="<?= $image; ?>" class="p-1 shadow mb-3" width="90" height="90" alt="Avatar">

                <h5 class="user-name mb-0 fw-bold"><?= $user['name']; ?></h5>
                <small class="text-muted mt-0 fmon"> <?= $user['role']; ?></small>
              </div>
            </a>
            <hr class="dropdown-divider" />
            <a class="dropdown-item d-flex align-items-center gap-2 py-2" href="<?= base_url(); ?>site/profile"><i
                class="material-icons-outlined">person_outline</i>Profile</a>

            <hr class="dropdown-divider" />
            <a class="dropdown-item d-flex align-items-center gap-2 py-2" href="<?= base_url(); ?>login/logout"><i
                class="material-icons-outlined">power_settings_new</i>Logout</a>
          </div>
        </li>
      </ul>


    </nav>
  </header>

  <!--end top header-->


  <!--start sidebar-->
  <aside class="sidebar-wrapper">
    <div class="sidebar-header">
      <div class="logo-icon">
      <img src="<?= base_url('assets/images/dplogo.png'); ?>" class="" width="150" alt="Logo">

      </div>
      <div class="logo-name flex-grow-1">

      </div>
      <div class="sidebar-close">
        <span class="material-icons-outlined">close</span>
      </div>
    </div>
    <div class="sidebar-nav" data-simplebar="true">

<?php

$currentRole=$this->session->userdata('session_data')['role'];

?>

      <!--navigation-->
      <ul class="metismenu" id="sidenav">
        <?php if($currentRole == 'admin'): ?>
        <li>
        <a href="<?= base_url('site/dashboard'); ?>" class="">
  <div class="icnonDiv">
    <img class="img1" src="<?= base_url('assets/images/megaIcons/d2.png'); ?>" alt="Dashboard Icon">
    <img class="img2" src="<?= base_url('assets/images/megaIcons/d1.png'); ?>" alt="Dashboard Icon Hover">
  </div>
  <div class="menu-title">Dashboard</div>
</a>
        </li>
        <?php endif; ?>
        <?php if($currentRole == 'admin' || $currentRole == 'content'): ?>
        <li>
          <a href="<?= base_url('foryou'); ?>" class="">
            <div class="icnonDiv">
              <i class="bi bi-play-btn-fill" style="font-size: 22px; color: #f7f9fc;"></i>
            </div>
            <div class="menu-title">For You</div>
          </a>
        </li>
        <?php endif; ?>
        <?php if($currentRole == 'admin' || $currentRole == 'userdepartment'): ?>
        <li>
         <a href="<?= base_url('site/users'); ?>" class="">
  <div class="icnonDiv">
    <img class="img1" src="<?= base_url('assets/images/megaIcons/with.png'); ?>" alt="Users Icon">
  </div>
  <div class="menu-title">Users</div>
</a>


        </li>
        <?php endif; ?>
        <?php if($currentRole == 'admin' || $currentRole == 'userdepartment'): ?>
         <li>
  <a href="<?= base_url('site/reports'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/Reports.png'); ?>" alt="Reports Icon">
    </div>
    <div class="menu-title">Reports</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'userdepartment'): ?>
<li>
  <a href="<?= base_url('site/warnings'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/Warnings.png'); ?>" alt="Warnings Icon">
    </div>
    <div class="menu-title">Warnings</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'content'): ?>
<li>
  <a href="<?= base_url('site/content'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/cont.png'); ?>" alt="Content Icon">
    </div>
    <div class="menu-title">Content</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'accountant'): ?>
<li>
  <a href="<?= base_url('site/revenue'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/rev.png'); ?>" alt="Revenue Icon">
    </div>
    <div class="menu-title">Revenue</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'accountant'): ?>
<li>
  <a href="<?= base_url('site/gifts'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/gift.png'); ?>" alt="Gifts & Coins Icon">
    </div>
    <div class="menu-title">Gifts & Coins</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'accountant'): ?>
<li>
  <a href="<?= base_url('site/transactions'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/tra.png'); ?>" alt="Transactions Icon">
    </div>
    <div class="menu-title">Transactions</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin'): ?>
<li>
  <a href="<?= base_url('site/announcement'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/ann.png'); ?>" alt="Announcements Icon">
    </div>
    <div class="menu-title">Announcements</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'content'): ?>
<li>
  <a href="<?= base_url('site/tick'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/tick.png'); ?>" alt="Blue Tick Icon">
    </div>
    <div class="menu-title">Blue Tick</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin'): ?>
<li>
  <a href="<?= base_url('admin/admins'); ?>" class="">
    <div class="icnonDiv">
      <i class="bi bi-people-fill" style="font-size: 24px; color:rgb(238, 243, 247);"></i>
    </div>
    <div class="menu-title">Role Management & Department</div>
  </a>
</li>
<?php endif; ?>
<?php if($currentRole == 'admin' || $currentRole == 'content'): ?>   


<li>
  <a href="<?= base_url('site/promotion'); ?>" class="">
    <div class="icnonDiv">
      <img class="img1" src="<?= base_url('assets/images/megaIcons/pro.png'); ?>" alt="Promotions Icon">
    </div>
    <div class="menu-title">Promotions</div>
  </a>
</li>
<?php endif; ?>




      </ul>
      <!--end navigation-->
    </div>

  </aside>
  <!--end sidebar-->

  <!-- Professional JS Enhancements -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Active menu detection
      const currentPath = window.location.pathname;
      const menuLinks = document.querySelectorAll('.metismenu a');
      
      menuLinks.forEach(link => {
        if (link.href && currentPath.includes(link.getAttribute('href'))) {
          link.classList.add('mm-active');
        }
      });

      // Smooth hover effects for icons
      const menuItems = document.querySelectorAll('.metismenu li a');
      menuItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
          this.style.transition = 'all 0.3s cubic-bezier(0.4, 0, 0.2, 1)';
        });
      });
    });
  </script>
