<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Login - Stream Admin</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" 
          integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" 
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" />
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="./assets/css/style.css" />
    
    <style>
        :root {
            --primary-color: #4f46e5;
            --primary-hover: #4338ca;
            --text-primary: #1f2937;
            --text-secondary: #6b7280;
            --border-color: #e5e7eb;
            --error-color: #ef4444;
            --success-color: #10b981;
        }

        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .login-card {
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 480px;
        }

        .logo-container {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo-container img {
            max-width: 180px;
            height: auto;
        }

        .login-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-primary);
            text-align: center;
            margin-bottom: 0.5rem;
        }

        .login-subtitle {
            font-size: 0.95rem;
            color: var(--text-secondary);
            text-align: center;
            margin-bottom: 2rem;
        }

        .form-group {
            margin-bottom: 1.25rem;
        }

        .form-label {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
            display: block;
        }

        .form-control-custom {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 1rem;
            border: 2px solid var(--border-color);
            border-radius: 8px;
            transition: all 0.3s ease;
            background-color: #ffffff;
        }

        .form-control-custom:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }

        .form-control-custom.is-invalid {
            border-color: var(--error-color);
        }

        .password-wrapper {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--text-secondary);
            transition: color 0.2s ease;
            user-select: none;
        }

        .password-toggle:hover {
            color: var(--text-primary);
        }

        .invalid-feedback {
            display: none;
            font-size: 0.875rem;
            color: var(--error-color);
            margin-top: 0.375rem;
        }

        .invalid-feedback.show {
            display: block;
        }

        .alert-custom {
            padding: 0.875rem 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            border: none;
        }

        .alert-danger {
            background-color: #fee2e2;
            color: #991b1b;
        }

        .alert-success {
            background-color: #d1fae5;
            color: #065f46;
        }

        .btn-login {
            width: 100%;
            padding: 0.875rem 1.5rem;
            font-size: 1rem;
            font-weight: 600;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
        }

        .btn-login:hover:not(:disabled) {
            background-color: var(--primary-hover);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(79, 70, 229, 0.3);
        }

        .btn-login:active:not(:disabled) {
            transform: translateY(0);
        }

        .btn-login:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }

        .btn-login .spinner {
            display: none;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.6s linear infinite;
            margin-right: 0.5rem;
        }

        .btn-login.loading .spinner {
            display: inline-block;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .forgot-password {
            text-align: center;
            margin-top: 1rem;
        }

        .forgot-password a {
            color: var(--primary-color);
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            transition: color 0.2s ease;
        }

        .forgot-password a:hover {
            color: var(--primary-hover);
            text-decoration: underline;
        }

        @media (max-width: 576px) {
            .login-card {
                padding: 2rem 1.5rem;
            }

            .login-title {
                font-size: 1.25rem;
            }
        }
    </style>
</head>

<body class="bgPrimary">
    <div class="login-container">
        <div class="login-card">
            <!-- Logo -->
            <div class="logo-container">
                <img src="./assets/images/logo.png" alt="Stream Admin Logo" />
            </div>

            <!-- Title -->
            <h1 class="login-title">Welcome Back</h1>
            <p class="login-subtitle">Enter your credentials to access your account</p>

            <!-- Error/Success Messages -->
            <?php if($this->session->flashdata('error')): ?>
                <div class="alert alert-danger alert-custom" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php endif; ?>

            <?php if($this->session->flashdata('success')): ?>
                <div class="alert alert-success alert-custom" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo $this->session->flashdata('success'); ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form id="loginForm" action="<?php echo base_url('login/login_action'); ?>" method="post" novalidate>
                <!-- Email Field -->
                <div class="form-group">
                    <label for="email" class="form-label">Email Address</label>
                    <input 
                        type="email" 
                        class="form-control-custom" 
                        id="email" 
                        name="email" 
                        placeholder="example@gmail.com"
                        autocomplete="email"
                        required
                        aria-describedby="emailError"
                    />
                    <div id="emailError" class="invalid-feedback">
                        Please enter a valid email address
                    </div>
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label for="password" class="form-label">Password</label>
                    <div class="password-wrapper">
                        <input 
                            type="password" 
                            class="form-control-custom" 
                            id="password" 
                            name="password" 
                            placeholder="Enter your password"
                            autocomplete="current-password"
                            required
                            minlength="6"
                            aria-describedby="passwordError"
                        />
                        <span class="password-toggle" id="togglePassword" aria-label="Toggle password visibility">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                    <div id="passwordError" class="invalid-feedback">
                        Password is required (minimum 6 characters)
                    </div>
                </div>

                <!-- Forgot Password Link (hidden by default) -->
                <div class="forgot-password d-none">
                    <a href="#" tabindex="-1">Forgot your password?</a>
                </div>

                <!-- Submit Button -->
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-login" id="loginBtn">
                        <span class="spinner"></span>
                        <span class="btn-text">Sign In</span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" 
            integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>

    <!-- Custom JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
            const togglePassword = document.getElementById('togglePassword');
            const loginBtn = document.getElementById('loginBtn');

            // Password visibility toggle
            togglePassword.addEventListener('click', function() {
                const type = passwordInput.type === 'password' ? 'text' : 'password';
                passwordInput.type = type;
                
                const icon = this.querySelector('i');
                icon.classList.toggle('fa-eye');
                icon.classList.toggle('fa-eye-slash');
            });

            // Email validation
            function validateEmail(email) {
                const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return re.test(email);
            }

            // Show error for field
            function showError(input, errorDiv) {
                input.classList.add('is-invalid');
                errorDiv.classList.add('show');
            }

            // Hide error for field
            function hideError(input, errorDiv) {
                input.classList.remove('is-invalid');
                errorDiv.classList.remove('show');
            }

            // Real-time validation
            emailInput.addEventListener('blur', function() {
                const emailError = document.getElementById('emailError');
                if (!this.value) {
                    emailError.textContent = 'Email address is required';
                    showError(this, emailError);
                } else if (!validateEmail(this.value)) {
                    emailError.textContent = 'Please enter a valid email address';
                    showError(this, emailError);
                } else {
                    hideError(this, emailError);
                }
            });

            emailInput.addEventListener('input', function() {
                if (this.value && validateEmail(this.value)) {
                    hideError(this, document.getElementById('emailError'));
                }
            });

            passwordInput.addEventListener('blur', function() {
                const passwordError = document.getElementById('passwordError');
                if (!this.value) {
                    passwordError.textContent = 'Password is required';
                    showError(this, passwordError);
                } else if (this.value.length < 6) {
                    passwordError.textContent = 'Password must be at least 6 characters';
                    showError(this, passwordError);
                } else {
                    hideError(this, passwordError);
                }
            });

            passwordInput.addEventListener('input', function() {
                if (this.value && this.value.length >= 6) {
                    hideError(this, document.getElementById('passwordError'));
                }
            });

            // Form submission
            loginForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                let isValid = true;
                const emailError = document.getElementById('emailError');
                const passwordError = document.getElementById('passwordError');

                // Validate email
                if (!emailInput.value) {
                    emailError.textContent = 'Email address is required';
                    showError(emailInput, emailError);
                    isValid = false;
                } else if (!validateEmail(emailInput.value)) {
                    emailError.textContent = 'Please enter a valid email address';
                    showError(emailInput, emailError);
                    isValid = false;
                } else {
                    hideError(emailInput, emailError);
                }

                // Validate password
                if (!passwordInput.value) {
                    passwordError.textContent = 'Password is required';
                    showError(passwordInput, passwordError);
                    isValid = false;
                } else if (passwordInput.value.length < 6) {
                    passwordError.textContent = 'Password must be at least 6 characters';
                    showError(passwordInput, passwordError);
                    isValid = false;
                } else {
                    hideError(passwordInput, passwordError);
                }

                // If validation passes, submit the form
                if (isValid) {
                    // Add loading state
                    loginBtn.disabled = true;
                    loginBtn.classList.add('loading');
                    
                    // Submit the form
                    this.submit();
                }
            });

            // Remove validation errors on focus
            emailInput.addEventListener('focus', function() {
                if (this.classList.contains('is-invalid')) {
                    hideError(this, document.getElementById('emailError'));
                }
            });

            passwordInput.addEventListener('focus', function() {
                if (this.classList.contains('is-invalid')) {
                    hideError(this, document.getElementById('passwordError'));
                }
            });
        });
    </script>
</body>
</html>
