<!--start main wrapper-->
<main class="main-wrapper">
    <div class="main-content">
        
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <h4 class="mb-0">My Profile</h4>
            </div>
        </div>

        <!-- Flash Messages -->
        <?php if($this->session->flashdata('success')): ?>
            <script>
                $(document).ready(function() {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: '<?= $this->session->flashdata('success') ?>',
                        confirmButtonColor: '#28a745'
                    });
                });
            </script>
        <?php endif; ?>

        <?php if($this->session->flashdata('error')): ?>
            <script>
                $(document).ready(function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: '<?= $this->session->flashdata('error') ?>',
                        confirmButtonColor: '#dc3545'
                    });
                });
            </script>
        <?php endif; ?>

        <!-- Profile Card -->
        <div class="row">
            <div class="col-lg-4 mb-4">
                <!-- Profile Summary Card -->
                <div class="card">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <img src="<?= isset($userinfo['profileImage']) ? $userinfo['profileImage'] : base_url('assets/images/avatars/01.png') ?>" 
                                 alt="Profile" 
                                 class="rounded-circle" 
                                 width="120" 
                                 height="120"
                                 id="profileImagePreview">
                        </div>
                        <h5 class="mb-1"><?= isset($userinfo['fullName']) ? $userinfo['fullName'] : 'Admin User' ?></h5>
                        <p class="text-muted mb-1"><?= isset($userinfo['email']) ? $userinfo['email'] : '' ?></p>
                        <p class="text-muted mb-3">
                            <span class="badge bg-primary"><?= isset($userinfo['role']) ? ucfirst($userinfo['role']) : 'Admin' ?></span>
                        </p>
                        <div class="d-flex justify-content-center gap-2">
                            <div class="text-center">
                                <small class="text-muted d-block">Status</small>
                                <?php if(isset($userinfo['isActive']) && $userinfo['isActive']): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?>
                            </div>
                            <div class="text-center">
                                <small class="text-muted d-block">Member Since</small>
                                <strong>
                                    <?php 
                                        if(isset($userinfo['createdDate'])) {
                                            echo date('M Y', $userinfo['createdDate'] / 1000);
                                        } else {
                                            echo 'N/A';
                                        }
                                    ?>
                                </strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                <!-- Tabs -->
                <div class="card">
                    <div class="card-header">
                        <ul class="nav nav-tabs card-header-tabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" 
                                    data-bs-target="#profile-info" type="button" role="tab">
                                    <i class="bi bi-person"></i> Profile Information
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="password-tab" data-bs-toggle="tab" 
                                    data-bs-target="#change-password" type="button" role="tab">
                                    <i class="bi bi-key"></i> Change Password
                                </button>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Profile Information Tab -->
                            <div class="tab-pane fade show active" id="profile-info" role="tabpanel">
                                <form action="<?= base_url('site/updateprofile') ?>" method="POST" enctype="multipart/form-data" id="profileForm">
                                    <input type="hidden" name="userId" value="<?= $userId ?>">
                                    
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="fullName" class="form-label">Full Name <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="fullName" name="fullName" 
                                                value="<?= isset($userinfo['fullName']) ? $userinfo['fullName'] : '' ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" id="email" name="email" 
                                                value="<?= isset($userinfo['email']) ? $userinfo['email'] : '' ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="phone" class="form-label">Phone <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="phone" name="phone" 
                                                value="<?= isset($userinfo['phone']) ? $userinfo['phone'] : '' ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="role" class="form-label">Role</label>
                                            <input type="text" class="form-control" id="role" 
                                                value="<?= isset($userinfo['role']) ? ucfirst($userinfo['role']) : 'Admin' ?>" readonly>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label for="profileImage" class="form-label">Profile Image</label>
                                            <input type="file" class="form-control" id="profileImage" name="profileImage" 
                                                accept="image/*" onchange="previewImage(this)">
                                            <small class="text-muted">Accepted formats: JPG, PNG, GIF (Max 5MB)</small>
                                        </div>

                                        <div class="col-12">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bi bi-check-circle"></i> Update Profile
                                            </button>
                                            <button type="reset" class="btn btn-secondary ms-2">
                                                <i class="bi bi-x-circle"></i> Reset
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <!-- Change Password Tab -->
                            <div class="tab-pane fade" id="change-password" role="tabpanel">
                                <form id="changePasswordForm">
                                    <input type="hidden" name="userId" value="<?= $userId ?>">
                                    
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="newPassword" class="form-label">New Password <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="newPassword" 
                                                    name="newPassword" required minlength="6">
                                                <button class="btn btn-outline-secondary" type="button" 
                                                    onclick="togglePassword('newPassword')">
                                                    <i class="bi bi-eye"></i>
                                                </button>
                                            </div>
                                            <small class="text-muted">Minimum 6 characters</small>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label for="confirmPassword" class="form-label">Confirm New Password <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="confirmPassword" 
                                                    name="confirmPassword" required minlength="6">
                                                <button class="btn btn-outline-secondary" type="button" 
                                                    onclick="togglePassword('confirmPassword')">
                                                    <i class="bi bi-eye"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="bi bi-shield-lock"></i> Change Password
                                            </button>
                                            <button type="reset" class="btn btn-secondary ms-2">
                                                <i class="bi bi-x-circle"></i> Clear
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!--end main wrapper-->

<script>
$(document).ready(function() {
    // Preview profile image
    window.previewImage = function(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#profileImagePreview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    // Toggle password visibility
    window.togglePassword = function(fieldId) {
        const field = $('#' + fieldId);
        const icon = field.next().find('i');
        
        if (field.attr('type') === 'password') {
            field.attr('type', 'text');
            icon.removeClass('bi-eye').addClass('bi-eye-slash');
        } else {
            field.attr('type', 'password');
            icon.removeClass('bi-eye-slash').addClass('bi-eye');
        }
    }

    // Handle password change form
    $('#changePasswordForm').on('submit', function(e) {
        e.preventDefault();

        const newPassword = $('#newPassword').val();
        const confirmPassword = $('#confirmPassword').val();

        // Validate password match
        if (newPassword !== confirmPassword) {
            Swal.fire({
                icon: 'error',
                title: 'Password Mismatch',
                text: 'New password and confirm password do not match',
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        // Show loading
        Swal.fire({
            title: 'Processing...',
            text: 'Changing password',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: '<?= base_url('site/changePassword') ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.message,
                        confirmButtonColor: '#28a745'
                    }).then(() => {
                        $('#changePasswordForm')[0].reset();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while changing password',
                    confirmButtonColor: '#dc3545'
                });
            }
        });
    });
});
</script>
