<?php
    $transactions = isset($transactions) && is_array($transactions) ? $transactions : [];
    $totalAmount = isset($totalAmount) ? (float)$totalAmount : 0.0;
    $totalAdminShare = isset($totalAdminShare) ? (float)$totalAdminShare : 0.0;
    $totalUserShare = isset($totalUserShare) ? (float)$totalUserShare : 0.0;
    $totalCoins = isset($totalCoins) ? (int)$totalCoins : 0;
    $transactionCount = isset($transactionCount) ? (int)$transactionCount : count($transactions);
    $filters = isset($filters) && is_array($filters) ? $filters : ['start_date' => date('Y-m-d'), 'end_date' => date('Y-m-d'), 'is_custom' => false];
    $startDateValue = htmlspecialchars($filters['start_date'] ?? date('Y-m-d'), ENT_QUOTES, 'UTF-8');
    $endDateValue = htmlspecialchars($filters['end_date'] ?? date('Y-m-d'), ENT_QUOTES, 'UTF-8');
    $currency = function ($value) {
        return number_format((float)$value, 2, '.', ',');
    };
?>

<main class="main-wrapper">
    <div class="main-content">
        <div class="d-flex flex-wrap justify-content-between align-items-start align-items-lg-center gap-3 mb-4">
            <div>
                <h2 class="fw-semibold mb-1">All Revenue</h2>
                <p class="text-muted mb-0">
                    <?php if (!empty($filters['is_custom'])): ?>
                        Showing transactions from <span class="fw-semibold"><?= $startDateValue; ?></span> to <span class="fw-semibold"><?= $endDateValue; ?></span>.
                    <?php else: ?>
                        Showing transactions for today (<?= $startDateValue; ?>).
                    <?php endif; ?>
                </p>
            </div>
            <form method="get" action="<?= htmlspecialchars(base_url('site/revenue'), ENT_QUOTES, 'UTF-8'); ?>" class="row g-2 align-items-center">
                <div class="col-auto">
                    <label for="revenueStartDate" class="form-label mb-0 text-muted small">Start date</label>
                    <input type="date" class="form-control" id="revenueStartDate" name="start_date" value="<?= $startDateValue; ?>" max="<?= date('Y-m-d'); ?>">
                </div>
                <div class="col-auto">
                    <label for="revenueEndDate" class="form-label mb-0 text-muted small">End date</label>
                    <input type="date" class="form-control" id="revenueEndDate" name="end_date" value="<?= $endDateValue; ?>" max="<?= date('Y-m-d'); ?>">
                </div>
                <div class="col-auto d-flex gap-2 pt-3 pt-md-4">
                    <button type="submit" class="btn btn-primary px-3">
                        <i class="bi bi-funnel me-1"></i>Filter
                    </button>
                    <a href="<?= htmlspecialchars(base_url('site/revenue'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-secondary px-3">
                        <i class="bi bi-arrow-counterclockwise me-1"></i>Reset
                    </a>
                </div>
            </form>
        </div>

        <div class="row g-3 mb-4">
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted text-uppercase fw-semibold small mb-1">Total Revenue</p>
                            <h3 class="mb-0">$<?= $currency($totalAmount); ?></h3>
                        </div>
                        <div class="avatar bg-primary bg-opacity-10 text-primary rounded-circle p-3">
                            <i class="bi bi-cash-stack fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted text-uppercase fw-semibold small mb-1">Admin Share</p>
                            <h3 class="mb-0">$<?= $currency($totalAdminShare); ?></h3>
                        </div>
                        <div class="avatar bg-success bg-opacity-10 text-success rounded-circle p-3">
                            <i class="bi bi-briefcase fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted text-uppercase fw-semibold small mb-1">User Share</p>
                            <h3 class="mb-0">$<?= $currency($totalUserShare); ?></h3>
                        </div>
                        <div class="avatar bg-warning bg-opacity-10 text-warning rounded-circle p-3">
                            <i class="bi bi-people fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted text-uppercase fw-semibold small mb-1">Total Coins</p>
                            <h3 class="mb-0"><?= number_format($totalCoins); ?></h3>
                        </div>
                        <div class="avatar bg-info bg-opacity-10 text-info rounded-circle p-3">
                            <i class="bi bi-coin fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex flex-wrap gap-2 mb-4">
            <a href="<?= htmlspecialchars(base_url('site/revenue'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-dark">
                <i class="bi bi-list-ul me-1"></i>All Revenue
            </a>
            <a href="<?= htmlspecialchars(base_url('site/revenueByUser'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-primary">
                <i class="bi bi-people me-1"></i>Revenue by User
            </a>
            <a href="<?= htmlspecialchars(base_url('site/revenueBreakdown'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-graph-up me-1"></i>Breakdown Overview
            </a>
            <a href="<?= htmlspecialchars(base_url('site/revenueCoins'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-info">
                <i class="bi bi-coin me-1"></i>Coins Analytics
            </a>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-bottom-0">
                <h5 class="mb-0">All Transactions</h5>
                <small class="text-muted">Detailed list of every transaction recorded in the selected range.</small>
            </div>
            <?php if (empty($transactions)): ?>
                <div class="card-body text-center text-muted py-5">
                    <i class="bi bi-receipt fs-1 d-block mb-3"></i>
                    No transactions were found for the selected period.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover table-nowrap mb-0 align-middle">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-muted text-uppercase small">Date &amp; Time</th>
                                <th class="text-muted text-uppercase small">Host</th>
                                <th class="text-muted text-uppercase small">Session</th>
                                <th class="text-muted text-uppercase small">Type</th>
                                <th class="text-muted text-uppercase small">Total Earning</th>
                                <th class="text-muted text-uppercase small">Admin Share</th>
                                <th class="text-muted text-uppercase small">User Share</th>
                                <th class="text-muted text-uppercase small">Coins</th>
                                <th class="text-muted text-uppercase small">Wallet Txn</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($transactions as $transaction): ?>
                                <?php
                                    $createdAt = isset($transaction['createdAtMs']) && $transaction['createdAtMs'] > 0
                                        ? date('M j, Y g:i A', $transaction['createdAtMs'] / 1000)
                                        : '—';
                                    $hostName = htmlspecialchars($transaction['hostName'] ?? 'Unknown host', ENT_QUOTES, 'UTF-8');
                                    $hostId = htmlspecialchars($transaction['hostId'] ?? '', ENT_QUOTES, 'UTF-8');
                                    $sessionId = htmlspecialchars($transaction['sessionId'] ?? '', ENT_QUOTES, 'UTF-8');
                                    $walletTxnId = htmlspecialchars($transaction['walletTransactionId'] ?? '', ENT_QUOTES, 'UTF-8');
                                    $typeLabel = htmlspecialchars($transaction['type'] ?? '', ENT_QUOTES, 'UTF-8');
                                    $amountValue = isset($transaction['amount']) ? $transaction['amount'] : 0;
                                    $adminShareValue = isset($transaction['adminShare']) ? $transaction['adminShare'] : 0;
                                    $userShareValue = isset($transaction['userShare']) ? $transaction['userShare'] : 0;
                                    $coinValue = isset($transaction['totalCoins']) ? (int)$transaction['totalCoins'] : 0;
                                ?>
                                <tr>
                                    <td><?= htmlspecialchars($createdAt, ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-semibold"><?= $hostName; ?></span>
                                            <?php if (!empty($hostId)): ?>
                                                <small class="text-muted"><?= $hostId; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if (!empty($sessionId)): ?>
                                            <code class="small text-muted"><?= $sessionId; ?></code>
                                        <?php else: ?>
                                            <span class="text-muted">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= !empty($typeLabel) ? $typeLabel : '<span class="text-muted">—</span>'; ?></td>
                                    <td>$<?= $currency($amountValue); ?></td>
                                    <td>$<?= $currency($adminShareValue); ?></td>
                                    <td>$<?= $currency($userShareValue); ?></td>
                                    <td><?= number_format($coinValue); ?></td>
                                    <td>
                                        <?php if (!empty($walletTxnId)): ?>
                                            <code class="small text-muted"><?= $walletTxnId; ?></code>
                                        <?php else: ?>
                                            <span class="text-muted">—</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

