<?php
    $systemTotals = isset($systemTotals) && is_array($systemTotals) ? $systemTotals : [];
    $currency = function ($value) {
        return number_format((float)$value, 2, '.', ',');
    };
    $systemLastUpdated = isset($systemTotals['lastUpdated']) && $systemTotals['lastUpdated'] > 0
        ? date('M j, Y g:i A', $systemTotals['lastUpdated'] / 1000)
        : null;
?>

<main class="main-wrapper">
    <div class="main-content">
        <div class="d-flex flex-wrap justify-content-between align-items-start align-items-lg-center gap-3 mb-4">
            <div>
                <h2 class="fw-semibold mb-1">Revenue Breakdown</h2>
                <p class="text-muted mb-0">Platform-wide revenue summary captured by analytics.</p>
            </div>
        </div>

        <ul class="nav nav-tabs custom-tabs mb-4" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenue'), ENT_QUOTES, 'UTF-8'); ?>">
                    All Revenue
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenueByUser'), ENT_QUOTES, 'UTF-8'); ?>">
                    Revenue by User
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <span class="nav-link active" aria-current="page">Breakdown</span>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenueCoins'), ENT_QUOTES, 'UTF-8'); ?>">
                    Coins
                </a>
            </li>
        </ul>

        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start flex-wrap gap-3 mb-4">
                    <div>
                        <h5 class="mb-1">System Recorded Totals</h5>
                        <small class="text-muted">Data snapshot from `analytics/totalrevenue`</small>
                    </div>
                    <?php if ($systemLastUpdated): ?>
                        <span class="badge bg-light text-muted">
                        <?php 
                if (isset($systemTotals['raw']['lastUpdatedAt']) && is_object($systemTotals['raw']['lastUpdatedAt'])) {
                    $timestamp = $systemTotals['raw']['lastUpdatedAt'];
                    // Google Cloud Timestamp object - use get() method to get DateTime object
                    try {
                        if (method_exists($timestamp, 'get')) {
                            $dateTime = $timestamp->get();
                            $formattedDate = $dateTime->format('Y-m-d H:i:s');
                        } elseif (method_exists($timestamp, 'format')) {
                            $formattedDate = $timestamp->format('Y-m-d H:i:s');
                        } else {
                            $formattedDate = (string)$timestamp;
                        }
                        echo '<p class="text-muted small mb-0">Raw Last Updated: ' . htmlspecialchars($formattedDate, ENT_QUOTES, 'UTF-8') . '</p>';
                    } catch (Exception $e) {
                        echo '<p class="text-muted small mb-0">Raw Last Updated: Error formatting date</p>';
                    }
                }
                ?>    
                        
                  </span>
                    <?php endif; ?>
                </div>

              

                <div class="row g-3 mb-4">
                    <div class="col-xl-3 col-sm-6">
                        <div class="border rounded-3 p-3 h-100">
                            <span class="text-muted text-uppercase small d-block mb-2">Total Revenue</span>
                            <h3 class="mb-0">$<?= $currency($systemTotals['totalRevenue'] ?? 0); ?></h3>
                        </div>
                    </div>
                    <div class="col-xl-3 col-sm-6">
                        <div class="border rounded-3 p-3 h-100">
                            <span class="text-muted text-uppercase small d-block mb-2">Admin Share</span>
                            <h4 class="mb-0">$<?= $currency($systemTotals['adminShare'] ?? 0); ?></h4>
                        </div>
                    </div>
                    <div class="col-xl-3 col-sm-6">
                        <div class="border rounded-3 p-3 h-100">
                            <span class="text-muted text-uppercase small d-block mb-2">User Share</span>
                            <h4 class="mb-0">$<?= $currency($systemTotals['userShare'] ?? 0); ?></h4>
                        </div>
                    </div>
                    <div class="col-xl-3 col-sm-6">
                        <div class="border rounded-3 p-3 h-100">
                            <span class="text-muted text-uppercase small d-block mb-2">Outstanding Payable</span>
                            <h4 class="mb-0">$<?= $currency($systemTotals['payable'] ?? 0); ?></h4>
                        </div>
                    </div>
                    <div class="col-xl-3 col-sm-6">
                        <div class="border rounded-3 p-3 h-100">
                            <span class="text-muted text-uppercase small d-block mb-2">Coins Earned</span>
                            <h4 class="mb-0"><?= number_format((float)($systemTotals['coinsEarned'] ?? 0), 0, '.', ','); ?></h4>
                        </div>
                    </div>
                </div>

              
            </div>
        </div>
    </div>
</main>

