<?php
    $totalAmount = isset($totalAmount) ? (float)$totalAmount : 0.0;
    $totalCoins = isset($totalCoins) ? (int)$totalCoins : 0;
    $transactionCount = isset($transactionCount) ? (int)$transactionCount : 0;
    $hostBreakdown = isset($hostBreakdown) && is_array($hostBreakdown) ? $hostBreakdown : [];
    $filters = isset($filters) && is_array($filters) ? $filters : ['start_date' => date('Y-m-d'), 'end_date' => date('Y-m-d'), 'is_custom' => false];
    $startDateValue = htmlspecialchars($filters['start_date'] ?? date('Y-m-d'), ENT_QUOTES, 'UTF-8');
    $endDateValue = htmlspecialchars($filters['end_date'] ?? date('Y-m-d'), ENT_QUOTES, 'UTF-8');
    $currency = function ($value) {
        return number_format((float)$value, 2, '.', ',');
    };
?>

<main class="main-wrapper">
    <div class="main-content">
        <div class="d-flex flex-wrap justify-content-between align-items-start align-items-lg-center gap-3 mb-4">
            <div>
                <h2 class="fw-semibold mb-1">Coins Analytics</h2>
                <p class="text-muted mb-0">
                    Insights for <span class="fw-semibold"><?= $startDateValue; ?></span>
                    to <span class="fw-semibold"><?= $endDateValue; ?></span>.
                </p>
            </div>
            <form method="get" action="<?= htmlspecialchars(base_url('site/revenueCoins'), ENT_QUOTES, 'UTF-8'); ?>" class="row g-2 align-items-center">
                <div class="col-auto">
                    <label for="coinsStartDate" class="form-label mb-0 text-muted small">Start date</label>
                    <input type="date" class="form-control" id="coinsStartDate" name="start_date" value="<?= $startDateValue; ?>" max="<?= date('Y-m-d'); ?>">
                </div>
                <div class="col-auto">
                    <label for="coinsEndDate" class="form-label mb-0 text-muted small">End date</label>
                    <input type="date" class="form-control" id="coinsEndDate" name="end_date" value="<?= $endDateValue; ?>" max="<?= date('Y-m-d'); ?>">
                </div>
                <div class="col-auto d-flex gap-2 pt-3 pt-md-4">
                    <button type="submit" class="btn btn-primary px-3">
                        <i class="bi bi-funnel me-1"></i>Filter
                    </button>
                    <a href="<?= htmlspecialchars(base_url('site/revenueCoins'), ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-outline-secondary px-3">
                        <i class="bi bi-arrow-counterclockwise me-1"></i>Reset
                    </a>
                </div>
            </form>
        </div>

        <ul class="nav nav-tabs custom-tabs mb-4" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenue'), ENT_QUOTES, 'UTF-8'); ?>">
                    All Revenue
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenueByUser'), ENT_QUOTES, 'UTF-8'); ?>">
                    Revenue by User
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" href="<?= htmlspecialchars(base_url('site/revenueBreakdown'), ENT_QUOTES, 'UTF-8'); ?>">
                    Breakdown
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <span class="nav-link active" aria-current="page">Coins</span>
            </li>
        </ul>

        <div class="row g-3 mb-4">
            <div class="col-xl-4 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <h6 class="text-muted text-uppercase small mb-2">Total Coins</h6>
                        <h3 class="fw-semibold"><?= number_format($totalCoins); ?></h3>
                        <p class="text-muted small mb-0">Coins collected within the selected period.</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <h6 class="text-muted text-uppercase small mb-2">Transactions</h6>
                        <h3 class="fw-semibold"><?= number_format($transactionCount); ?></h3>
                        <p class="text-muted small mb-0">Total transactions that generated coins.</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <?php $averageCoins = $transactionCount > 0 ? $totalCoins / $transactionCount : 0; ?>
                        <h6 class="text-muted text-uppercase small mb-2">Average Coins / Txn</h6>
                        <h3 class="fw-semibold"><?= number_format($averageCoins, 2); ?></h3>
                        <p class="text-muted small mb-0">Helps gauge transaction efficiency.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white border-bottom-0">
                <h5 class="mb-0">Coins vs Revenue Snapshot</h5>
                <small class="text-muted">Quick reference for total revenue alongside coin metrics.</small>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-4 mb-3 mb-md-0">
                        <span class="text-muted text-uppercase small d-block">Total Revenue</span>
                        <span class="fs-4 fw-semibold d-block mt-1">$<?= $currency($totalAmount); ?></span>
                    </div>
                    <div class="col-md-4 mb-3 mb-md-0">
                        <span class="text-muted text-uppercase small d-block">Total Coins</span>
                        <span class="fs-4 fw-semibold d-block mt-1"><?= number_format($totalCoins); ?></span>
                    </div>
                    <div class="col-md-4">
                        <span class="text-muted text-uppercase small d-block">Revenue / Coin</span>
                        <?php $revenuePerCoin = $totalCoins > 0 ? $totalAmount / $totalCoins : 0; ?>
                        <span class="fs-4 fw-semibold d-block mt-1">$<?= number_format($revenuePerCoin, 4, '.', ','); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-bottom-0">
                <h5 class="mb-0">Coins by Host</h5>
                <small class="text-muted">Hosts ranked by the coin volume they generated.</small>
            </div>
            <?php if (empty($hostBreakdown)): ?>
                <div class="card-body text-center text-muted py-5">
                    <i class="bi bi-coin fs-1 d-block mb-3"></i>
                    No coin data to show for this period.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover table-nowrap mb-0 align-middle">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-muted text-uppercase small">Host</th>
                                <th class="text-muted text-uppercase small">Coins</th>
                                <th class="text-muted text-uppercase small">Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $coinsRanking = $hostBreakdown;
                                usort($coinsRanking, static function ($a, $b) {
                                    return ($b['totalCoins'] ?? 0) <=> ($a['totalCoins'] ?? 0);
                                });
                            ?>
                            <?php foreach ($coinsRanking as $host): ?>
                                <?php
                                    $hostName = htmlspecialchars($host['hostName'] ?? 'Unknown host', ENT_QUOTES, 'UTF-8');
                                    $hostId = htmlspecialchars($host['hostId'] ?? '', ENT_QUOTES, 'UTF-8');
                                ?>
                                <tr>
                                    <td>
                                        <a href="<?= base_url('host/viewHost/'.$hostId); ?>">
                                        <div class="d-flex flex-column">
                                            <span class="fw-semibold"><?= $hostName; ?></span>
                                            <?php if (!empty($hostId)): ?>
                                                    <small class="text-muted"><?= $hostId; ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </a>
                                    </td>
                                    <td><?= number_format((int)($host['totalCoins'] ?? 0)); ?></td>
                                    <td>$<?= $currency($host['totalAmount'] ?? 0); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

