 <!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">

        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-md-8">
                <h4 class="mb-0">Role & Department Management</h4>
                <p class="text-muted mb-0">Manage departments, roles, and permissions</p>
            </div>
            <div class="col-md-4 text-end">
                <span class="badge bg-primary fs-6">Total Admins: <?= $totalAdmins ?></span>
                </div>
                </div>

        <!-- Department Overview Cards -->
        <div class="row mb-4">
            <?php foreach ($departments as $deptKey => $dept): ?>
                <div class="col-md-6 col-lg-3 mb-3">
                    <div class="card border-<?= $dept['color'] ?> h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="flex-shrink-0">
                                    <i class="bi bi-<?= $dept['icon'] ?> text-<?= $dept['color'] ?>" style="font-size: 2rem;"></i>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-0"><?= $dept['name'] ?></h6>
                                    <small class="text-muted"><?= count($dept['roles']) ?> Roles</small>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="text-muted">Members:</span>
                                <h4 class="mb-0 text-<?= $dept['color'] ?>">
                                    <?= isset($departmentCounts[$deptKey]) ? $departmentCounts[$deptKey] : 0 ?>
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            </div>

        <!-- Department Details Accordion -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Departments & Roles</h5>
            </div>
                <div class="card-body">
                <div class="accordion" id="departmentAccordion">
                    <?php $accordionIndex = 0; foreach ($departments as $deptKey => $dept): $accordionIndex++; ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="heading<?= $accordionIndex ?>">
                                <button class="accordion-button <?= $accordionIndex !== 1 ? 'collapsed' : '' ?>" type="button" 
                                    data-bs-toggle="collapse" data-bs-target="#collapse<?= $accordionIndex ?>" 
                                    aria-expanded="<?= $accordionIndex === 1 ? 'true' : 'false' ?>">
                                    <i class="bi bi-<?= $dept['icon'] ?> text-<?= $dept['color'] ?> me-2"></i>
                                    <strong><?= $dept['name'] ?></strong>
                                    <span class="badge bg-<?= $dept['color'] ?> ms-3">
                                        <?= isset($departmentCounts[$deptKey]) ? $departmentCounts[$deptKey] : 0 ?> Members
                                    </span>
                                                </button>
                            </h2>
                            <div id="collapse<?= $accordionIndex ?>" 
                                class="accordion-collapse collapse <?= $accordionIndex === 1 ? 'show' : '' ?>" 
                                data-bs-parent="#departmentAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <?php foreach ($dept['roles'] as $roleKey => $role): ?>
                                            <div class="col-md-6 col-lg-4 mb-3">
                                                <div class="card h-100 border-<?= $dept['color'] ?>">
                                                    <div class="card-body">
                                                        <h6 class="card-title text-<?= $dept['color'] ?>">
                                                            <i class="bi bi-person-badge"></i>
                                                            <?= $role['title'] ?>
                                                        </h6>
                                                        <p class="card-text text-muted small mb-3">
                                                            <?= $role['description'] ?>
                                                        </p>
                                                        
                                                        <div class="mb-2">
                                                            <strong class="small">Permissions:</strong>
                                                            <div class="mt-1">
                                                                <?php foreach ($role['permissions'] as $permission): ?>
                                                                    <span class="badge bg-light text-dark border me-1 mb-1">
                                                                        <i class="bi bi-check-circle text-success"></i>
                                                                        <?= $permission ?>
                                                                    </span>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="mt-3">
                                                            <small class="text-muted">Assigned:</small>
                                                            <strong class="text-<?= $dept['color'] ?>">
                                                                <?= isset($roleCounts[$roleKey]) ? $roleCounts[$roleKey] : 0 ?> Users
                                                            </strong>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Role Assignment Guide -->
        <div class="card mt-4">
            <div class="card-header bg-light">
                <h5 class="mb-0"><i class="bi bi-info-circle"></i> Quick Guide</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center p-3">
                            <i class="bi bi-shield-fill-check text-danger" style="font-size: 2rem;"></i>
                            <h6 class="mt-2">Admin Panel</h6>
                            <p class="small text-muted">HR, Access & Settings Management</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center p-3">
                            <i class="bi bi-camera-video text-primary" style="font-size: 2rem;"></i>
                            <h6 class="mt-2">Media Panel</h6>
                            <p class="small text-muted">Content, Promotions & Verification</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center p-3">
                            <i class="bi bi-people-fill text-info" style="font-size: 2rem;"></i>
                            <h6 class="mt-2">User Panel</h6>
                            <p class="small text-muted">User Management & Compliance</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center p-3">
                            <i class="bi bi-currency-dollar text-success" style="font-size: 2rem;"></i>
                            <h6 class="mt-2">Finance Panel</h6>
                            <p class="small text-muted">Revenue, Gifts & Transactions</p>
                        </div>
                    </div>
                    </div>

                <hr>

                <div class="alert alert-info mb-0">
                    <strong><i class="bi bi-lightbulb"></i> Note:</strong>
                    To assign roles to users, go to <a href="<?= base_url('admin/admins') ?>" class="alert-link">Admin Users</a> section.
                    Department Managers have access to all modules within their department.
                </div>
            </div>
        </div>

        </div>
    </main>
    <!--end main wrapper-->

<script>
$(document).ready(function() {
    // Any additional JavaScript for role management
    console.log('Role Management Page Loaded');
});
</script>
