<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Role Management</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>admin/admins" class="btn btn-secondary">
          <i class="bi bi-people"></i> View All Admins
        </a>
      </div>
    </div>

    <!-- Role Statistics -->
    <div class="row mb-4">
      <div class="col-md-3">
        <div class="card bg-info text-white">
          <div class="card-body">
            <h6><i class="bi bi-people-fill"></i> Total Admins</h6>
            <h2><?php echo isset($roleCounts['total']) ? $roleCounts['total'] : 0; ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-danger text-white">
          <div class="card-body">
            <h6><i class="bi bi-shield-fill-check"></i> Administrators</h6>
            <h2><?php echo isset($roleCounts['admin']) ? $roleCounts['admin'] : 0; ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-primary text-white">
          <div class="card-body">
            <h6><i class="bi bi-file-earmark-text"></i> Content Managers</h6>
            <h2><?php echo isset($roleCounts['content']) ? $roleCounts['content'] : 0; ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-success text-white">
          <div class="card-body">
            <h6><i class="bi bi-calculator"></i> Accountants</h6>
            <h2><?php echo isset($roleCounts['accountant']) ? $roleCounts['accountant'] : 0; ?></h2>
          </div>
        </div>
      </div>
    </div>

    <!-- Roles Details -->
    <?php
    if(isset($roles)) {
        foreach($roles as $roleKey => $roleData) {
            $cardClass = 'border-'.$roleData['color'];
            $badgeClass = 'bg-'.$roleData['color'];
    ?>
    <div class="card mb-3 <?php echo $cardClass; ?>">
      <div class="card-header <?php echo $badgeClass; ?> text-white">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">
            <i class="bi bi-<?php echo $roleData['icon']; ?>"></i> 
            <?php echo $roleData['name']; ?>
          </h5>
          <a href="<?php echo base_url().'role/viewByRole/'.$roleKey; ?>" class="btn btn-light btn-sm">
            <i class="bi bi-people"></i> View Users (<?php echo isset($roleCounts[$roleKey]) ? $roleCounts[$roleKey] : 0; ?>)
          </a>
        </div>
      </div>
      <div class="card-body">
        <p class="text-muted"><?php echo $roleData['description']; ?></p>
        
        <h6 class="mt-3 mb-2">Permissions:</h6>
        <div class="row">
          <?php
          foreach($roleData['permissions'] as $permission => $hasAccess) {
              $icon = $hasAccess ? 'check-circle-fill text-success' : 'x-circle-fill text-danger';
              echo '<div class="col-md-3 col-sm-4 col-6 mb-2">';
              echo '<i class="bi bi-'.$icon.'"></i> '.$permission;
              echo '</div>';
          }
          ?>
        </div>
      </div>
    </div>
    <?php
        }
    }
    ?>

    <!-- Role Comparison Table -->
    <div class="card mt-4">
      <div class="card-header bg-dark text-white">
        <h6 class="mb-0"><i class="bi bi-table"></i> Role Comparison Matrix</h6>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered align-middle">
            <thead class="table-light">
              <tr>
                <th>Module</th>
                <th class="text-center"><i class="bi bi-shield-fill-check text-danger"></i> Admin</th>
                <th class="text-center"><i class="bi bi-file-earmark-text text-primary"></i> Content</th>
                <th class="text-center"><i class="bi bi-calculator text-success"></i> Accountant</th>
              </tr>
            </thead>
            <tbody>
              <?php
              $allModules = array('Dashboard', 'Users Management', 'Customers Management', 'Announcements', 
                                'Promotions', 'Gifts', 'Transactions', 'Revenue', 'Reports', 'Settings', 
                                'Admin Management', 'Role Management');
              
              foreach($allModules as $module) {
                  echo '<tr>';
                  echo '<td><strong>'.$module.'</strong></td>';
                  
                  // Admin column
                  $hasAccess = isset($roles['admin']['permissions'][$module]) && $roles['admin']['permissions'][$module];
                  echo '<td class="text-center">';
                  echo $hasAccess ? '<i class="bi bi-check-circle-fill text-success fs-5"></i>' : '<i class="bi bi-x-circle-fill text-danger fs-5"></i>';
                  echo '</td>';
                  
                  // Content column
                  $hasAccess = isset($roles['content']['permissions'][$module]) && $roles['content']['permissions'][$module];
                  echo '<td class="text-center">';
                  echo $hasAccess ? '<i class="bi bi-check-circle-fill text-success fs-5"></i>' : '<i class="bi bi-x-circle-fill text-danger fs-5"></i>';
                  echo '</td>';
                  
                  // Accountant column
                  $hasAccess = isset($roles['accountant']['permissions'][$module]) && $roles['accountant']['permissions'][$module];
                  echo '<td class="text-center">';
                  echo $hasAccess ? '<i class="bi bi-check-circle-fill text-success fs-5"></i>' : '<i class="bi bi-x-circle-fill text-danger fs-5"></i>';
                  echo '</td>';
                  
                  echo '</tr>';
              }
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

