<style>
    .rejection-reason-box {
        background-color: #f8d7da;
        border: 1px solid #f5c2c7;
        border-radius: 6px;
        padding: 10px;
        color: #842029;
        margin-top: 10px;
    }
</style>

<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-x-circle text-danger"></i> Rejected Tick Requests</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('tick/requests'); ?>" class="btn btn-warning">
          <i class="bi bi-clock-history"></i> View Pending Requests
        </a>
      </div>
    </div>

    <div class="row my-2">
      <div class="col-md-12">
        <form action="<?= base_url('tick/rejected'); ?>" method="post">
          <div class="input-group custom-search">
            <span class="input-group-text"><i class="bi bi-search"></i></span>
            <input type="text" class="form-control" name="searchText" placeholder="Search by name, username or email..." 
                   value="<?= !empty($searchText) ? htmlspecialchars($searchText) : ''; ?>" aria-label="Search">
            <button type="submit" class="btn btn-primary">Search</button>
            <?php if(!empty($searchText)): ?>
            <a href="<?= base_url('tick/rejected'); ?>" class="btn btn-secondary">Clear</a>
            <?php endif; ?>
          </div>
        </form>
      </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs custom-tabs" id="tickTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?= base_url('tick/requests'); ?>">
          <i class="bi bi-clock-history"></i> Pending Requests
        </a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?= base_url('tick/verified'); ?>">
          <i class="bi bi-patch-check-fill"></i> Verified Users
        </a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link active" href="<?= base_url('tick/rejected'); ?>">
          <i class="bi bi-x-circle"></i> Rejected Requests (<?= count($rejectedUsers); ?>)
        </a>
      </li>
    </ul>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
      <?php
      if(!empty($rejectedUsers)) {
          foreach($rejectedUsers as $userId => $user) {
              $fullName = isset($user['fullName']) ? $user['fullName'] : 'N/A';
              $userName = isset($user['userName']) ? $user['userName'] : 'N/A';
              $email = isset($user['email']) ? $user['email'] : 'N/A';
              $followersCount = isset($user['userFollowers']) ? count($user['userFollowers']) : 0;
              $followingCount = isset($user['userFollowings']) ? count($user['userFollowings']) : 0;
              $userCoins = isset($user['userCoins']) ? $user['userCoins'] : 0;
              
              // Format rejection date
              $rejectedDate = 'N/A';
              if (isset($user['tickRejectedDate']) && is_numeric($user['tickRejectedDate'])) {
                  $timestamp = $user['tickRejectedDate'] / 1000;
                  $rejectedDate = date('M d, Y g:i A', $timestamp);
              }
              
              $rejectionReason = isset($user['tickRejectionReason']) ? $user['tickRejectionReason'] : 'No reason provided';
      ?>
      
      <div class="col-md-6 mb-4">
        <div class="report-card">
          <!-- Header -->
          <div class="report-header" style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);">
            <i class="bi bi-person-circle"></i> <?= htmlspecialchars($fullName); ?> (@<?= htmlspecialchars($userName); ?>)
          </div>

          <!-- Body -->
          <div class="report-body p-3">
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">User:</div>
              <div><?= htmlspecialchars($email); ?></div>
            </div>
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">Followers:</div>
              <div><?= number_format($followersCount); ?></div>
            </div>
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">Following:</div>
              <div><?= number_format($followingCount); ?></div>
            </div>
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">Coins:</div>
              <div><?= number_format($userCoins); ?></div>
            </div>
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">Status:</div>
              <div><span class="badge bg-danger">rejected</span></div>
            </div>
            <div class="d-flex gap-2 align-items-center mb-2">
              <div class="report-label">Rejected:</div>
              <div><?= $rejectedDate; ?></div>
            </div>
            
            <!-- Rejection Reason -->
            <div class="rejection-reason-box">
              <strong><i class="bi bi-exclamation-circle"></i> Rejection Reason:</strong><br>
              <?= htmlspecialchars($rejectionReason); ?>
            </div>
          </div>
        </div>
      </div>
      
      <?php
          }
      } else {
          echo '<div class="col-12"><div class="alert alert-info"><i class="bi bi-info-circle"></i> No rejected tick requests found.</div></div>';
      }
      ?>
    </div>
  </div>
</main>
<!--end main wrapper-->

