<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4><i class="bi bi-patch-check-fill text-primary"></i> Verified Users</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?= base_url('tick/requests'); ?>" class="btn btn-warning">
          <i class="bi bi-clock-history"></i> View Pending Requests
        </a>
      </div>
    </div>

    <div class="row my-2">
      <div class="col-md-12">
        <form action="<?= base_url('tick/verified'); ?>" method="post">
          <div class="input-group custom-search">
            <span class="input-group-text"><i class="bi bi-search"></i></span>
            <input type="text" class="form-control" name="searchText" placeholder="Search by name, username or email..." 
                   value="<?= !empty($searchText) ? htmlspecialchars($searchText) : ''; ?>" aria-label="Search">
            <button type="submit" class="btn btn-primary">Search</button>
            <?php if(!empty($searchText)): ?>
            <a href="<?= base_url('tick/verified'); ?>" class="btn btn-secondary">Clear</a>
            <?php endif; ?>
          </div>
        </form>
      </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs custom-tabs" id="tickTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?= base_url('tick/requests'); ?>">
          <i class="bi bi-clock-history"></i> Pending Requests
        </a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link active" href="<?= base_url('tick/verified'); ?>">
          <i class="bi bi-patch-check-fill"></i> Verified Users (<?= count($verifiedUsers); ?>)
        </a>
      </li>
      <li class="nav-item" role="presentation">
        <a class="nav-link" href="<?= base_url('tick/rejected'); ?>">
          <i class="bi bi-x-circle"></i> Rejected Requests
        </a>
      </li>
    </ul>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    
    if(!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
            <?= $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif;
    
    if(!empty($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
            <?= $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered align-middle">
            <thead>
              <tr>
                <th>#</th>
                <th>User</th>
                <th>Email</th>
                <th>Username</th>
                <th>Followers</th>
                <th>Following</th>
                <th>Coins</th>
                <th>Verified Since</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              if(!empty($verifiedUsers)) {
                  $count = 1;
                  foreach($verifiedUsers as $userId => $user) {
                      $fullName = isset($user['fullName']) ? $user['fullName'] : 'N/A';
                      $userName = isset($user['userName']) ? $user['userName'] : 'N/A';
                      $email = isset($user['email']) ? $user['email'] : 'N/A';
                      $followersCount = isset($user['userFollowers']) ? count($user['userFollowers']) : 0;
                      $followingCount = isset($user['userFollowings']) ? count($user['userFollowings']) : 0;
                      $userCoins = isset($user['userCoins']) ? $user['userCoins'] : 0;
                      $approvedDate = isset($user['tickApprovedDate']) ? date('Y-m-d H:i', $user['tickApprovedDate'] / 1000) : 'N/A';
              ?>
              <tr>
                <td><?= $count++; ?></td>
                <td>
                  <strong><?= htmlspecialchars($fullName); ?></strong>
                  <i class="bi bi-patch-check-fill text-primary" title="Verified"></i>
                </td>
                <td><?= htmlspecialchars($email); ?></td>
                <td>
                  <span class="badge bg-dark">@<?= htmlspecialchars($userName); ?></span>
                </td>
                <td><i class="bi bi-people-fill"></i> <?= number_format($followersCount); ?></td>
                <td><i class="bi bi-person-fill"></i> <?= number_format($followingCount); ?></td>
                <td><i class="bi bi-coin"></i> <?= number_format($userCoins); ?></td>
                <td><?= $approvedDate; ?></td>
                <td>
                  <a href="<?= base_url('customer/viewCustomer/'.$userId); ?>" class="btn btn-sm btn-info" title="View User">
                    <i class="bi bi-eye"></i>
                  </a>
                  <button class="btn btn-sm btn-warning revokeTick" 
                          data-userid="<?= $userId; ?>" 
                          data-email="<?= htmlspecialchars($email); ?>" 
                          data-name="<?= htmlspecialchars($fullName); ?>" 
                          title="Revoke Tick">
                    <i class="bi bi-slash-circle"></i> Revoke
                  </button>
                </td>
              </tr>
              <?php
                  }
              } else {
              ?>
              <tr>
                <td colspan="9" class="text-center">
                  <div class="py-4">
                    <i class="bi bi-patch-check" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-2">No verified users yet</p>
                  </div>
                </td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script>
$(document).ready(function() {
    // Revoke Blue Tick
    $('.revokeTick').click(function(e) {
        e.preventDefault();
        var userId = $(this).data('userid');
        var email = $(this).data('email');
        var userName = $(this).data('name');
        
        Swal.fire({
            title: 'Revoke Blue Tick?',
            html: '<strong>' + userName + '</strong><br><br>' +
                  'This will remove the verified badge from this user.<br><br>' +
                  '<textarea id="revoke-reason" class="swal2-textarea" placeholder="Reason for revocation (optional)"></textarea>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: '<i class="bi bi-slash-circle"></i> Revoke',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                var reason = document.getElementById('revoke-reason').value;
                
                Swal.fire({
                    title: 'Revoking...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?= base_url('tick/revokeTick'); ?>',
                    type: 'POST',
                    data: { 
                        userId: userId,
                        email: email,
                        reason: reason
                    },
                    dataType: 'json',
                    success: function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                title: 'Revoked',
                                text: response.message,
                                icon: 'info',
                                confirmButtonColor: '#0d6efd'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    }
                });
            }
        });
    });
});
</script>

