<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Add New User</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>user/users" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Users
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>user/addNewUser" method="post" id="addUserForm">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="name" class="form-label">Full Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="name" name="name" required 
                     value="<?php echo set_value('name'); ?>">
              <span class="text-danger"><?php echo form_error('name'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
              <input type="email" class="form-control" id="email" name="email" required 
                     value="<?php echo set_value('email'); ?>">
              <span class="text-danger"><?php echo form_error('email'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
              <input type="password" class="form-control" id="password" name="password" required>
              <span class="text-danger"><?php echo form_error('password'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="cpassword" class="form-label">Confirm Password <span class="text-danger">*</span></label>
              <input type="password" class="form-control" id="cpassword" name="cpassword" required>
              <span class="text-danger"><?php echo form_error('cpassword'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="phone" name="phone" required 
                     value="<?php echo set_value('phone'); ?>">
              <span class="text-danger"><?php echo form_error('phone'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="balance" class="form-label">Balance</label>
              <input type="number" class="form-control" id="balance" name="balance" step="0.01" 
                     value="<?php echo set_value('balance', '0'); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label for="agent" class="form-label">Select Agent <span class="text-danger">*</span></label>
              <select class="form-select" id="agent" name="agent" required>
                <option value="">Select Agent</option>
                <?php
                if(!empty($agents)) {
                    foreach($agents as $agent) {
                        echo '<option value="'.$agent->id.'">'.htmlspecialchars($agent->name).' ('.$agent->email.')</option>';
                    }
                }
                ?>
              </select>
              <span class="text-danger"><?php echo form_error('agent'); ?></span>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Save User
              </button>
              <button type="reset" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Reset
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

