<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Edit User</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>user/users" class="btn btn-secondary">
          <i class="bi bi-arrow-left"></i> Back to Users
        </a>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <form action="<?php echo base_url(); ?>user/updateUser" method="post" id="editUserForm">
          <input type="hidden" name="userId" value="<?php echo $userInfo->id; ?>">
          
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="name" class="form-label">Full Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="name" name="name" required 
                     value="<?php echo !empty($userInfo->name) ? $userInfo->name : set_value('name'); ?>">
              <span class="text-danger"><?php echo form_error('name'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
              <input type="email" class="form-control" id="email" name="email" required 
                     value="<?php echo !empty($userInfo->email) ? $userInfo->email : set_value('email'); ?>">
              <span class="text-danger"><?php echo form_error('email'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="password" class="form-label">Password</label>
              <input type="password" class="form-control" id="password" name="password" 
                     placeholder="Leave empty to keep current password">
              <span class="text-danger"><?php echo form_error('password'); ?></span>
              <small class="text-muted">Leave empty to keep current password</small>
            </div>

            <div class="col-md-6 mb-3">
              <label for="cpassword" class="form-label">Confirm Password</label>
              <input type="password" class="form-control" id="cpassword" name="cpassword" 
                     placeholder="Leave empty to keep current password">
              <span class="text-danger"><?php echo form_error('cpassword'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="phone" name="phone" required 
                     value="<?php echo !empty($userInfo->phone) ? $userInfo->phone : set_value('phone'); ?>">
              <span class="text-danger"><?php echo form_error('phone'); ?></span>
            </div>

            <div class="col-md-6 mb-3">
              <label for="balance" class="form-label">Balance</label>
              <input type="number" class="form-control" id="balance" name="balance" step="0.01" 
                     value="<?php echo !empty($userInfo->balance) ? $userInfo->balance : '0'; ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label for="agent" class="form-label">Select Agent <span class="text-danger">*</span></label>
              <select class="form-select" id="agent" name="agent" required>
                <option value="">Select Agent</option>
                <?php
                if(!empty($agents)) {
                    foreach($agents as $agent) {
                        $selected = ($agent->id == $userInfo->parent_id) ? 'selected' : '';
                        echo '<option value="'.$agent->id.'" '.$selected.'>'.htmlspecialchars($agent->name).' ('.$agent->email.')</option>';
                    }
                }
                ?>
              </select>
              <span class="text-danger"><?php echo form_error('agent'); ?></span>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update User
              </button>
              <a href="<?php echo base_url(); ?>user/users" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
              </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

